/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.blocks;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.entities.ConstructionBlockEntity;
import com.direwolf20.buildinggadgets.common.registry.objects.BGBlocks;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tiles.EffectBlockTileEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EffectBlock
extends Block {
    public static void spawnEffectBlock(World world, BlockPos spawnPos, BlockData spawnBlock, Mode mode, boolean usePaste) {
        BlockState state = BGBlocks.effectBlock.func_176223_P();
        TileEntity curTe = world.func_175625_s(spawnPos);
        BlockState curState = world.func_180495_p(spawnPos);
        world.func_175656_a(spawnPos, state);
        assert (world.func_175625_s(spawnPos) != null);
        ((EffectBlockTileEntity)world.func_175625_s(spawnPos)).initializeData(world, curState, curTe, spawnBlock, mode, usePaste);
        world.func_184138_a(spawnPos, state, state, 3);
    }

    public EffectBlock(Block.Properties builder) {
        super(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EffectBlockTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder loot) {
        return new ArrayList<ItemStack>();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public static enum Mode {
        PLACE{

            @Override
            public void onBuilderRemoved(EffectBlockTileEntity builder) {
                World world = builder.func_145831_w();
                BlockPos targetPos = builder.func_174877_v();
                BlockData targetBlock = builder.getRenderedBlock();
                if (builder.isUsingPaste()) {
                    world.func_175656_a(targetPos, BGBlocks.constructionBlock.func_176223_P());
                    TileEntity te = world.func_175625_s(targetPos);
                    if (te instanceof ConstructionBlockTileEntity) {
                        ((ConstructionBlockTileEntity)te).setBlockState(targetBlock, targetBlock);
                    }
                    world.func_217376_c((Entity)new ConstructionBlockEntity(world, targetPos, false));
                } else {
                    world.func_217377_a(targetPos, false);
                    targetBlock.placeIn(SimpleBuildContext.builder().build((IWorld)world), targetPos);
                    BlockPos upPos = targetPos.func_177984_a();
                    world.func_180495_p(targetPos).func_215697_a(world, targetPos, world.func_180495_p(upPos).func_177230_c(), upPos, false);
                }
            }
        }
        ,
        REMOVE{

            @Override
            public void onBuilderRemoved(EffectBlockTileEntity builder) {
                builder.func_145831_w().func_217377_a(builder.func_174877_v(), false);
            }
        }
        ,
        REPLACE{

            @Override
            public void onBuilderRemoved(EffectBlockTileEntity builder) {
                EffectBlock.spawnEffectBlock(builder.func_145831_w(), builder.func_174877_v(), builder.getSourceBlock(), PLACE, builder.isUsingPaste());
            }
        };

        public static final Mode[] VALUES;

        public abstract void onBuilderRemoved(EffectBlockTileEntity var1);

        static {
            VALUES = Mode.values();
        }
    }
}

