/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common;

import com.direwolf20.buildinggadgets.api.BuildingGadgetsAPI;
import com.direwolf20.buildinggadgets.client.ClientProxy;
import com.direwolf20.buildinggadgets.client.gui.GuiMod;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.config.crafting.RecipeConstructionPaste;
import com.direwolf20.buildinggadgets.common.events.AnvilRepairHandler;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.registry.objects.BuildingObjects;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="buildinggadgets")
public final class BuildingGadgets {
    public static Logger LOG = LogManager.getLogger();
    private static BuildingGadgets theMod = null;
    private final BuildingGadgetsAPI theAPi = new BuildingGadgetsAPI();

    public static BuildingGadgets getInstance() {
        assert (theMod != null);
        return theMod;
    }

    public BuildingGadgets() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_CONFIG);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::serverLoad);
        eventBus.addListener(this::finishLoad);
        eventBus.addGenericListener(IRecipeSerializer.class, this::onRecipeRegister);
        eventBus.addListener(Config::onLoad);
        eventBus.addListener(Config::onFileChange);
        MinecraftForge.EVENT_BUS.register((Object)new AnvilRepairHandler());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            eventBus.addListener(event -> ClientProxy.clientSetup(eventBus));
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> GuiMod::openScreen);
        });
        BuildingObjects.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        theMod = (BuildingGadgets)ModLoadingContext.get().getActiveContainer().getMod();
        DeferredWorkQueue.runLater(PacketHandler::register);
    }

    private void serverLoad(FMLServerStartingEvent event) {
    }

    private void finishLoad(FMLLoadCompleteEvent event) {
        BuildingObjects.cleanup();
    }

    private void onRecipeRegister(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        e.getRegistry().register(RecipeConstructionPaste.Serializer.INSTANCE.setRegistryName(new ResourceLocation("buildinggadgets", "construction_paste")));
    }
}

