/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renderer;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Comparator;

public enum SphereSegmentation {
    HIGH_SEGMENTATION(64, 64),
    MEDIUM_HIGH_SEGMENTATION(48, 256),
    MEDIUM_SEGMENTATION(32, 576),
    LOW_SEGMENTATION(16, 1024);

    public static final Comparator<SphereSegmentation> BY_DISTANCE;
    public static final ImmutableList<SphereSegmentation> VALUES;
    private final int segments;
    private final int maxDist;

    private SphereSegmentation(int segments, int maxDist) {
        this.segments = segments;
        this.maxDist = maxDist;
    }

    public int getSegments() {
        return this.segments;
    }

    private int getMaxSquareDist() {
        return this.maxDist;
    }

    public static SphereSegmentation forSquareDist(double dist) {
        for (int i = 0; i < VALUES.size() - 1; ++i) {
            SphereSegmentation value = (SphereSegmentation)((Object)VALUES.get(i));
            if (!((double)value.getMaxSquareDist() <= dist)) continue;
            return value;
        }
        return (SphereSegmentation)((Object)VALUES.get(VALUES.size() - 1));
    }

    static {
        BY_DISTANCE = Comparator.comparing(SphereSegmentation::getMaxSquareDist);
        VALUES = ImmutableList.sortedCopyOf(BY_DISTANCE, Arrays.asList(SphereSegmentation.values()));
    }
}

