/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renderer;

import com.direwolf20.buildinggadgets.client.renderer.SphereSegmentation;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.tiles.ChargingStationTileEntity;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ChargingStationTER
extends TileEntityRenderer<ChargingStationTileEntity> {
    private static final float CHARGE_UPDATE_BORDER = 0.005f;

    public void render(ChargingStationTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        ItemStack stack = te.getRenderStack();
        if (!stack.func_190926_b()) {
            GlStateManager.pushLightingAttributes();
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)x, (double)y, (double)z);
            GlStateManager.disableRescaleNormal();
            this.renderItem(te);
            this.renderSphere(te);
            if (te.isChargingItem((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY).orElseThrow(CapabilityNotPresentException::new)) && SphereSegmentation.BY_DISTANCE.compare(te.getLastRenderedSegmentation(), SphereSegmentation.MEDIUM_SEGMENTATION) < 0) {
                this.renderLightning(te);
            }
            GlStateManager.popMatrix();
            GlStateManager.popAttributes();
        }
    }

    private void renderLightning(ChargingStationTileEntity te) {
        float red = 1.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float alpha = 1.0f;
        GlStateManager.pushMatrix();
        GlStateManager.pushLightingAttributes();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.disableTexture();
        GlStateManager.translated((double)0.5, (double)1.0, (double)0.5);
        GlStateManager.shadeModel((int)7425);
        GlStateManager.disableDepthTest();
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = t.func_178180_c();
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        GlStateManager.lineWidth((float)3.0f);
        double x2 = te.getLightningX();
        double z2 = te.getLightningZ();
        bufferBuilder.func_181662_b(x2, 0.0, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_181662_b(0.0, 0.5, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        t.func_78381_a();
        GlStateManager.enableDepthTest();
        GlStateManager.disableBlend();
        GlStateManager.enableTexture();
        GlStateManager.popAttributes();
        GlStateManager.popMatrix();
    }

    private void renderSphere(ChargingStationTileEntity te) {
        float charge;
        if (!((Boolean)Config.CHARGING_STATION.renderSphere.get()).booleanValue()) {
            te.updateSegmentation(te.getSegmentation());
            return;
        }
        float lastCharge = te.getLastChargeFactor();
        if (lastCharge > (charge = te.getChargeFactor()) + 0.005f || lastCharge < charge - 0.005f || charge == 1.0f && lastCharge != 1.0f || charge == 0.0f && lastCharge != 0.0f) {
            te.updateChargeFactor(charge);
            this.createCallList(te);
        } else {
            SphereSegmentation newSegmentation;
            SphereSegmentation lastSegmentation = te.getLastRenderedSegmentation();
            if (lastSegmentation != (newSegmentation = te.getSegmentation())) {
                te.updateSegmentation(newSegmentation);
                this.createCallList(te, newSegmentation);
            } else if (te.getCallList() == 0) {
                this.createCallList(te);
            } else {
                GlStateManager.callList((int)te.getCallList());
            }
        }
    }

    private void createCallList(ChargingStationTileEntity te) {
        te.updateSegmentation(te.getSegmentation());
        this.createCallList(te, te.getSegmentation());
    }

    private void createCallList(ChargingStationTileEntity te, SphereSegmentation segmentation) {
        if (te.getCallList() == 0) {
            te.genCallList();
        }
        GlStateManager.newList((int)te.getCallList(), (int)4865);
        this.performRenderSphere(te, segmentation.getSegments());
        GlStateManager.endList();
    }

    private void performRenderSphere(ChargingStationTileEntity te, int segments) {
        double radius1 = 0.0;
        double radius2 = 0.0;
        double radius = 0.33;
        double angle = 0.0;
        double dAngle = Math.PI / (double)segments;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float red = Math.min(2.0f * (1.0f - te.getLastChargeFactor()), 1.0f);
        float green = Math.min(2.0f * te.getLastChargeFactor(), 1.0f);
        float blue = 0.0f;
        float alpha = 0.5f;
        GlStateManager.pushMatrix();
        GlStateManager.pushLightingAttributes();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.disableTexture();
        GlStateManager.translated((double)0.5, (double)1.5, (double)0.5);
        GlStateManager.shadeModel((int)7425);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = t.func_178180_c();
        bufferBuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < segments; ++i) {
            angle = 1.5707963267948966 - (double)i * dAngle;
            radius1 = radius * Math.cos(angle);
            float z1 = (float)(radius * Math.sin(angle));
            float c1 = (float)((1.5707963267948966 + angle) / Math.PI);
            angle = 1.5707963267948966 - (double)(i + 1) * dAngle;
            radius2 = radius * Math.cos(angle);
            float z2 = (float)(radius * Math.sin(angle));
            float c2 = (float)((1.5707963267948966 + angle) / Math.PI);
            for (int j = 0; j <= 2 * segments; ++j) {
                double cda = Math.cos((double)j * dAngle);
                double sda = Math.sin((double)j * dAngle);
                x = (float)(radius1 * cda);
                y = (float)(radius1 * sda);
                bufferBuilder.func_181662_b((double)x, (double)y, (double)z1).func_181666_a(red, green, blue, alpha).func_181675_d();
                x = (float)(radius2 * cda);
                y = (float)(radius2 * sda);
                bufferBuilder.func_181662_b((double)x, (double)y, (double)z2).func_181666_a(red, green, blue, alpha).func_181675_d();
            }
        }
        t.func_78381_a();
        GlStateManager.disableBlend();
        GlStateManager.enableTexture();
        GlStateManager.popAttributes();
        GlStateManager.popMatrix();
    }

    private void renderParticles(ChargingStationTileEntity te) {
    }

    private void renderItem(ChargingStationTileEntity te) {
        ItemStack stack = te.getRenderStack();
        RenderHelper.func_74519_b();
        GlStateManager.enableLighting();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.5, (double)1.5, (double)0.5);
        GlStateManager.scalef((float)0.4f, (float)0.4f, (float)0.4f);
        float rotation = this.func_178459_a().func_82737_E() % 80L;
        GlStateManager.rotatef((float)(360.0f * rotation / 80.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.popMatrix();
    }
}

