/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui;

import com.direwolf20.buildinggadgets.client.gui.CopyGUI;
import com.direwolf20.buildinggadgets.client.gui.DestructionGUI;
import com.direwolf20.buildinggadgets.client.gui.PasteGUI;
import com.direwolf20.buildinggadgets.client.gui.blocks.ChargingStationGUI;
import com.direwolf20.buildinggadgets.client.gui.blocks.TemplateManagerGUI;
import com.direwolf20.buildinggadgets.client.gui.components.GuiTextFieldBase;
import com.direwolf20.buildinggadgets.common.containers.ChargingStationContainer;
import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.tiles.ChargingStationTileEntity;
import com.direwolf20.buildinggadgets.common.tiles.TemplateManagerTileEntity;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.awt.Color;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public enum GuiMod {
    COPY((Function<PlayerEntity, ItemStack>)((Function)GadgetCopyPaste::getGadget), (Function<ItemStack, ? extends Screen>)((Function)CopyGUI::new)),
    PASTE((Function<PlayerEntity, ItemStack>)((Function)GadgetCopyPaste::getGadget), (Function<ItemStack, ? extends Screen>)((Function)PasteGUI::new)),
    DESTRUCTION((Function<PlayerEntity, ItemStack>)((Function)GadgetDestruction::getGadget), (Function<ItemStack, ? extends Screen>)((Function)DestructionGUI::new)),
    TEMPLATE_MANAGER("buildinggadgets:template_manager_container", (Function<FMLPlayMessages.OpenContainer, ? extends Screen>)((Function)message -> {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.getAdditionalData().func_179259_c());
        return te instanceof TemplateManagerTileEntity ? new TemplateManagerGUI((TemplateManagerTileEntity)te, GuiMod.getTemplateManagerContainer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, te), Minecraft.func_71410_x().field_71439_g.field_71071_by) : null;
    }), (id, player, world, pos) -> {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TemplateManagerTileEntity) {
            GuiMod.openGuiContainer(id, player, GuiMod.getTemplateManagerContainer((PlayerEntity)player, te), buffer -> buffer.func_179255_a(pos));
            return true;
        }
        return false;
    }),
    CHARGING_STATION("buildinggadgets:charging_station_container", (Function<FMLPlayMessages.OpenContainer, ? extends Screen>)((Function)message -> {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.getAdditionalData().func_179259_c());
        return te instanceof ChargingStationTileEntity ? new ChargingStationGUI((ChargingStationTileEntity)te, GuiMod.getChargingStationContainer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, te), Minecraft.func_71410_x().field_71439_g.field_71071_by) : null;
    }), (id, player, world, pos) -> {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ChargingStationTileEntity) {
            GuiMod.openGuiContainer(id, player, GuiMod.getChargingStationContainer((PlayerEntity)player, te), buffer -> buffer.func_179255_a(pos));
            return true;
        }
        return false;
    });

    private Function<PlayerEntity, ItemStack> stackReader;
    private Function<ItemStack, ? extends Screen> clientScreenProvider;
    private Function<FMLPlayMessages.OpenContainer, ? extends Screen> commonScreenProvider;
    private IContainerOpener containerOpener;
    private String id;

    private GuiMod(Function<PlayerEntity, ItemStack> stackReader, Function<ItemStack, ? extends Screen> clientScreenProvider) {
        this.stackReader = stackReader;
        this.clientScreenProvider = clientScreenProvider;
    }

    private GuiMod(String id, Function<FMLPlayMessages.OpenContainer, ? extends Screen> commonScreenProvider, IContainerOpener containerOpener) {
        this.id = id;
        this.commonScreenProvider = commonScreenProvider;
        this.containerOpener = containerOpener;
    }

    public static Screen openScreen(Minecraft minecraft, Screen screen) {
        return null;
    }

    public boolean openScreen(PlayerEntity player) {
        if (this.clientScreenProvider == null) {
            return false;
        }
        ItemStack stack = (ItemStack)this.stackReader.apply((Object)player);
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        Screen screen = (Screen)this.clientScreenProvider.apply((Object)stack);
        Minecraft.func_71410_x().func_147108_a(screen);
        return screen == null;
    }

    public boolean openContainer(PlayerEntity player, World world, BlockPos pos) {
        return this.containerOpener != null && player instanceof ServerPlayerEntity && this.containerOpener.open(this.id, (ServerPlayerEntity)player, world, pos);
    }

    public static Screen openScreen(FMLPlayMessages.OpenContainer message) {
        return null;
    }

    private static TemplateManagerContainer getTemplateManagerContainer(PlayerEntity player, TileEntity te) {
        return new TemplateManagerContainer(0, player.field_71071_by, (TemplateManagerTileEntity)te);
    }

    private static ChargingStationContainer getChargingStationContainer(PlayerEntity player, TileEntity te) {
        return new ChargingStationContainer(0, player.field_70170_p, te.func_174877_v(), player.field_71071_by, player);
    }

    private static void openGuiContainer(String id, ServerPlayerEntity player, final Container container, Consumer<PacketBuffer> extraDataWriter) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return null;
            }

            @Nullable
            public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                return container;
            }
        }, extraDataWriter);
    }

    public static String getLangKeyField(String prefix, String name) {
        return GuiMod.getLangKey(prefix, "field", name);
    }

    public static String getLangKeyButton(String prefix, String name) {
        return GuiMod.getLangKey(prefix, "button", name);
    }

    public static String getLangKeyArea(String prefix, String name) {
        return GuiMod.getLangKey(prefix, "area", name);
    }

    public static String getLangKey(String prefix, String type, String name) {
        return LangUtil.getLangKey("gui", prefix, type, name);
    }

    public static String getLangKeySingle(String name) {
        return LangUtil.getLangKey("gui", "single", name);
    }

    public static void setEmptyField(GuiTextFieldBase field, Supplier<Integer> value) {
        if (field.func_146179_b().isEmpty()) {
            field.func_146180_a(String.valueOf(value.get()));
        }
    }

    public static boolean sizeCheckBoxes(Iterator<GuiTextFieldBase> fields, int min, int max) {
        while (fields.hasNext()) {
            int n = fields.next().getInt();
            if (n >= min && n <= max) continue;
            return false;
        }
        return true;
    }

    public static Color getColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    private static interface IContainerOpener {
        public boolean open(String var1, ServerPlayerEntity var2, World var3, BlockPos var4);
    }
}

