/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui;

import com.direwolf20.buildinggadgets.client.gui.GuiMod;
import com.direwolf20.buildinggadgets.client.gui.components.GuiSliderInt;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketDestructionGUI;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class DestructionGUI
extends Screen {
    private GuiDestructionSlider left;
    private GuiDestructionSlider right;
    private GuiDestructionSlider up;
    private GuiDestructionSlider down;
    private GuiDestructionSlider depth;
    private ItemStack destructionTool;

    public DestructionGUI(ItemStack tool) {
        super((ITextComponent)new StringTextComponent("Destruction Gui?!?"));
        this.destructionTool = tool;
    }

    public void init() {
        super.init();
        int x = this.width / 2;
        int y = this.height / 2;
        this.addButton((Widget)new Button(x - 30 + 32, y + 60, 60, 20, I18n.func_135052_a((String)GuiMod.getLangKeySingle("confirm"), (Object[])new Object[0]), b -> {
            if (this.isWithinBounds()) {
                PacketHandler.sendToServer(new PacketDestructionGUI(this.left.getValueInt(), this.right.getValueInt(), this.up.getValueInt(), this.down.getValueInt(), this.depth.getValueInt()));
                this.onClose();
            } else {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + new TranslationTextComponent("message.gadget.destroysizeerror", new Object[0]).func_150261_e()), true);
            }
        }));
        this.addButton((Widget)new Button(x - 30 - 32, y + 60, 60, 20, I18n.func_135052_a((String)GuiMod.getLangKeySingle("cancel"), (Object[])new Object[0]), b -> this.onClose()));
        ArrayList<GuiDestructionSlider> sliders = new ArrayList<GuiDestructionSlider>();
        this.depth = new GuiDestructionSlider(x - 35, y - 7, "Depth", GadgetDestruction.getToolValue(this.destructionTool, "depth"));
        sliders.add(this.depth);
        this.left = new GuiDestructionSlider(x - 140 - 5, y - 7, "Left", GadgetDestruction.getToolValue(this.destructionTool, "left"));
        sliders.add(this.left);
        this.right = new GuiDestructionSlider(x + 75, y - 7, "Right", GadgetDestruction.getToolValue(this.destructionTool, "right"));
        sliders.add(this.right);
        this.up = new GuiDestructionSlider(x - 35, y - 35, "Up", GadgetDestruction.getToolValue(this.destructionTool, "up"));
        sliders.add(this.up);
        this.down = new GuiDestructionSlider(x - 35, y + 20, "Down", GadgetDestruction.getToolValue(this.destructionTool, "down"));
        sliders.add(this.down);
        sliders.forEach(gui -> gui.getComponents().forEach(arg_0 -> ((DestructionGUI)this).addButton(arg_0)));
    }

    private boolean isWithinBounds() {
        int x = this.left.getValueInt() + this.right.getValueInt();
        int y = this.up.getValueInt() + this.down.getValueInt();
        return x <= 16 && y <= 16;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static class GuiDestructionSlider
    extends GuiSliderInt {
        public static final int width = 70;
        public static final int height = 14;
        private static final int min = 0;
        private static final int max = 16;

        GuiDestructionSlider(int x, int y, String prefix, int current) {
            super(x, y, 70, 14, String.format("%s ", prefix), "", 0.0, 16.0, current, false, true, Color.DARK_GRAY, null, (slider, amount) -> {
                slider.setValue(MathHelper.func_76125_a((int)(slider.getValueInt() + amount), (int)0, (int)16));
                slider.updateSlider();
            });
        }
    }
}

