/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.template;

import com.direwolf20.buildinggadgets.api.Registries;
import com.direwolf20.buildinggadgets.api.building.PlacementTarget;
import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.api.building.view.IBuildView;
import com.direwolf20.buildinggadgets.api.exceptions.ConcurrentTransactionExecutionException;
import com.direwolf20.buildinggadgets.api.exceptions.TemplateException;
import com.direwolf20.buildinggadgets.api.exceptions.TemplateViewAlreadyClosedException;
import com.direwolf20.buildinggadgets.api.exceptions.TransactionExecutionException;
import com.direwolf20.buildinggadgets.api.exceptions.TransactionInvalidException;
import com.direwolf20.buildinggadgets.api.materials.MaterialList;
import com.direwolf20.buildinggadgets.api.serialisation.ITemplateSerializer;
import com.direwolf20.buildinggadgets.api.serialisation.TemplateHeader;
import com.direwolf20.buildinggadgets.api.template.IBuildOpenOptions;
import com.direwolf20.buildinggadgets.api.template.ITemplate;
import com.direwolf20.buildinggadgets.api.template.ImmutableTemplate;
import com.direwolf20.buildinggadgets.api.template.SimpleBuildOpenOptions;
import com.direwolf20.buildinggadgets.api.template.transaction.ITemplateTransaction;
import com.direwolf20.buildinggadgets.api.template.transaction.ITransactionOperator;
import com.direwolf20.buildinggadgets.api.template.transaction.ReplaceDelegateOperator;
import com.direwolf20.buildinggadgets.api.util.DelegatingSpliterator;
import com.direwolf20.buildinggadgets.api.util.RegistryUtils;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DelegatingTemplate
implements ITemplate {
    private ITemplate delegate;
    private Object delegateLock;
    private Set<IBuildView> activeViews;
    private boolean transactionActive;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITemplate unwrap(ITemplate template) {
        if (template instanceof DelegatingTemplate) {
            ITemplate delegate;
            DelegatingTemplate castTemplate = (DelegatingTemplate)template;
            Object object = castTemplate.getDelegateLock();
            synchronized (object) {
                delegate = castTemplate.getDelegate();
            }
            return DelegatingTemplate.unwrap(delegate);
        }
        return template;
    }

    public static DelegatingTemplate createUnwrapped(ITemplate template) {
        return new DelegatingTemplate(DelegatingTemplate.unwrap(template));
    }

    public DelegatingTemplate(ITemplate delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.delegateLock = new Object();
        this.activeViews = Collections.newSetFromMap(new IdentityHashMap());
        this.transactionActive = false;
    }

    public DelegatingTemplate() {
        this(ImmutableTemplate.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ITemplateTransaction startTransaction() {
        ITemplateTransaction delegateTransaction;
        Object object = this.getDelegateLock();
        synchronized (object) {
            if (this.isTransactionActive()) {
                return null;
            }
            delegateTransaction = this.getDelegate().startTransaction();
            if (delegateTransaction == null) {
                return null;
            }
            this.markTransactionActive();
        }
        return new DelegatingTransaction(this, delegateTransaction);
    }

    @Override
    public ITemplateSerializer getSerializer() {
        return this.getDelegate().getSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBuildView createViewInContext(IBuildOpenOptions openOptions) {
        switch (openOptions.getOpenType()) {
            case DEFAULT: {
                return new DelegatingBuildView(this, openOptions);
            }
            case IF_NO_TRANSACTION_OPEN: {
                Object object = this.getDelegateLock();
                synchronized (object) {
                    if (!this.transactionActive) {
                        return new DelegatingBuildView(this, openOptions);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    protected ITemplate getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(ITemplate delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Cannot have a null delegate!");
    }

    protected Object getDelegateLock() {
        return this.delegateLock;
    }

    protected Set<IBuildView> getActiveViews() {
        return this.activeViews;
    }

    protected boolean isTransactionActive() {
        return this.transactionActive;
    }

    protected void markTransactionActive() {
        this.transactionActive = true;
    }

    protected void markTransactionFinished() {
        this.transactionActive = false;
    }

    public static class DelegatingTransaction
    implements ITemplateTransaction {
        private DelegatingTemplate template;
        private ITemplateTransaction transaction;
        private List<ITransactionOperator> operators;
        private ReplaceDelegateOperator replaceOp;

        protected DelegatingTransaction(DelegatingTemplate template, ITemplateTransaction transaction) {
            this.template = template;
            this.transaction = transaction;
            this.operators = new LinkedList<ITransactionOperator>();
            this.replaceOp = null;
        }

        @Override
        public ITemplateTransaction operate(ITransactionOperator operator) {
            Preconditions.checkState((this.transaction != null && this.template != null ? 1 : 0) != 0, (Object)"Transaction has already been executed!");
            if (operator instanceof ReplaceDelegateOperator) {
                this.replaceOp = (ReplaceDelegateOperator)operator;
            } else {
                this.operators.add(Objects.requireNonNull(operator, "Cannot have a null Operator!"));
            }
            return this;
        }

        @Override
        public ITemplate execute(@Nullable IBuildContext context) throws TransactionExecutionException {
            if (this.transaction == null || this.template == null) {
                throw new TransactionInvalidException("Cannot execute Transaction Twice!");
            }
            if (this.replaceOp != null) {
                this.applyResultAndReplaceOrComplete(this.replaceOp.getNewDelegate(), !this.operators.isEmpty());
            }
            if (!this.operators.isEmpty()) {
                for (ITransactionOperator operator : this.operators) {
                    this.transaction.operate(operator);
                }
                ITemplate result = this.transaction.execute(context);
                return this.applyResultAndReplaceOrComplete(result, false);
            }
            if (this.replaceOp != null) {
                return this.invalidateNoFinish();
            }
            return this.invalidate(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ITemplate applyResultAndReplaceOrComplete(ITemplate newDelegate, boolean replaceTransaction) throws TransactionExecutionException {
            if (replaceTransaction) {
                this.transaction.execute(null);
            }
            Object object = this.template.getDelegateLock();
            synchronized (object) {
                if (!this.template.getActiveViews().isEmpty()) {
                    this.invalidate(false);
                    throw new ConcurrentTransactionExecutionException("Cannot apply delegate Template whilst a BuildView is present!");
                }
                this.template.setDelegate(newDelegate);
                if (!replaceTransaction) {
                    return this.invalidate(false);
                }
                this.transaction = newDelegate.startTransaction();
            }
            return this.template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ITemplate invalidate(boolean requireSync) {
            if (requireSync) {
                Object object = this.template.getDelegateLock();
                synchronized (object) {
                    this.template.markTransactionFinished();
                }
            } else {
                this.template.markTransactionFinished();
            }
            return this.invalidateNoFinish();
        }

        protected ITemplate invalidateNoFinish() {
            DelegatingTemplate res = this.template;
            this.template = null;
            this.transaction = null;
            return res;
        }
    }

    public static class DelegatingBuildView
    implements IBuildView {
        private IBuildView view;
        private IBuildContext context;
        private DelegatingTemplate template;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DelegatingBuildView(DelegatingTemplate template, IBuildOpenOptions openOptions) {
            Object object = template.getDelegateLock();
            synchronized (object) {
                template.getActiveViews().add(this);
                this.view = template.getDelegate().createViewInContext(SimpleBuildOpenOptions.builderCopyOf(openOptions).openType(IBuildOpenOptions.OpenType.DEFAULT).build());
            }
            this.template = template;
            this.context = openOptions.getContext();
        }

        @Override
        public Spliterator<PlacementTarget> spliterator() {
            if (this.template == null || this.view == null) {
                throw new UnsupportedOperationException("Cannot create a Spliterator for an already closed IBuildView!");
            }
            return new DelegatingBuildSpliterator(this.view.spliterator());
        }

        @Override
        public IBuildView translateTo(BlockPos pos) {
            this.validateOpen();
            return this.view.translateTo(pos);
        }

        @Override
        public int estimateSize() {
            this.validateOpen();
            return this.view.estimateSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws TemplateException {
            if (this.template == null || this.view == null) {
                throw new TemplateViewAlreadyClosedException("Cannot close already closed view!");
            }
            try {
                Object object = this.template.getDelegateLock();
                synchronized (object) {
                    this.template.getActiveViews().remove(this);
                    this.view.close();
                }
            }
            finally {
                this.template = null;
                this.view = null;
            }
        }

        @Override
        public IBuildView copy() {
            this.validateOpen();
            return new DelegatingBuildView(this.template, SimpleBuildOpenOptions.builder().context(this.getContext()).build());
        }

        @Override
        public IBuildContext getContext() {
            return this.context;
        }

        @Override
        public Region getBoundingBox() {
            this.validateOpen();
            return this.view.getBoundingBox();
        }

        @Override
        public boolean mayContain(int x, int y, int z) {
            this.validateOpen();
            return this.view.mayContain(x, y, z);
        }

        @Override
        public MaterialList estimateRequiredItems(@Nullable Vec3d simulatePos) {
            this.validateOpen();
            return this.view.estimateRequiredItems(simulatePos);
        }

        protected void validateOpen() {
            Preconditions.checkState((this.getTemplate() != null && this.getView() != null ? 1 : 0) != 0, (Object)"Cannot access already closed BuildView!");
        }

        @Nullable
        protected IBuildView getView() {
            return this.view;
        }

        @Nullable
        protected DelegatingTemplate getTemplate() {
            return this.template;
        }

        public class DelegatingBuildSpliterator
        extends DelegatingSpliterator<PlacementTarget, PlacementTarget> {
            protected DelegatingBuildSpliterator(Spliterator<PlacementTarget> other) {
                super(other);
            }

            @Override
            protected boolean advance(PlacementTarget object, Consumer<? super PlacementTarget> action) {
                action.accept(object);
                return true;
            }

            @Override
            @Nullable
            public Spliterator<PlacementTarget> trySplit() {
                Spliterator<PlacementTarget> other = this.getOther().trySplit();
                if (other != null) {
                    return new DelegatingBuildSpliterator(other);
                }
                return null;
            }
        }
    }

    public static class DelegatingTemplateSerializer
    extends ForgeRegistryEntry<ITemplateSerializer>
    implements ITemplateSerializer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TemplateHeader createHeaderFor(ITemplate template) {
            ITemplate delegateTemplate;
            assert (this.getRegistryName() != null);
            DelegatingTemplate castTemplate = (DelegatingTemplate)template;
            Object object = castTemplate.getDelegateLock();
            synchronized (object) {
                delegateTemplate = castTemplate.getDelegate();
            }
            TemplateHeader delegateHeader = delegateTemplate.getSerializer().createHeaderFor(delegateTemplate);
            return TemplateHeader.builderOf(delegateHeader, this.getRegistryName(), delegateHeader.getBoundingBox()).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompoundNBT serialize(ITemplate template, boolean persisted) {
            ITemplate delegate;
            DelegatingTemplate castTemplate = (DelegatingTemplate)template;
            CompoundNBT nbt = new CompoundNBT();
            Object object = castTemplate.getDelegateLock();
            synchronized (object) {
                delegate = castTemplate.getDelegate();
            }
            assert (delegate.getSerializer().getRegistryName() != null);
            if (persisted) {
                nbt.func_74778_a("serializer", delegate.getSerializer().getRegistryName().toString());
            } else {
                nbt.func_74768_a("serializer", RegistryUtils.getId(Registries.getTemplateSerializers(), delegate.getSerializer()));
            }
            nbt.func_218657_a("data", (INBT)delegate.getSerializer().serialize(delegate, persisted));
            return nbt;
        }

        @Override
        public ITemplate deserialize(CompoundNBT tagCompound, @Nullable TemplateHeader header, boolean persisted) {
            ITemplateSerializer serializer = null;
            if (tagCompound.func_150297_b("serializer", 3)) {
                serializer = RegistryUtils.getById(Registries.getTemplateSerializers(), tagCompound.func_74762_e("serializer"));
            }
            if (serializer == null && tagCompound.func_150297_b("serializer", 8)) {
                ResourceLocation serializerId = new ResourceLocation(tagCompound.func_74779_i("serializer"));
                serializer = (ITemplateSerializer)Registries.getTemplateSerializers().getValue(serializerId);
            }
            Preconditions.checkArgument((serializer != null ? 1 : 0) != 0, (Object)"Cannot construct a Delegating Template with unknown Delegate Serializer. Expected Int or String 'serializer' to be present!");
            assert (serializer.getRegistryName() != null);
            CompoundNBT data = tagCompound.func_74775_l("data");
            ITemplate delegate = serializer.deserialize(data, header != null ? TemplateHeader.builderOf(header, serializer.getRegistryName(), header.getBoundingBox()).build() : null, persisted);
            return new DelegatingTemplate(delegate);
        }
    }
}

