/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.serialisation;

import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.materials.MaterialList;
import com.direwolf20.buildinggadgets.api.serialisation.ITemplateSerializer;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;

public final class TemplateHeader {
    @Nullable
    private final String name;
    @Nullable
    private final String author;
    @Nullable
    private final MaterialList requiredItems;
    @Nonnull
    private final ResourceLocation serializer;
    @Nonnull
    private final Region boundingBox;

    public static Builder builder(ITemplateSerializer serializer, Region boundingBox) {
        return TemplateHeader.builder(Objects.requireNonNull(serializer.getRegistryName()), boundingBox);
    }

    public static Builder builder(ResourceLocation serializer, Region boundingBox) {
        return new Builder(serializer, boundingBox);
    }

    public static Builder builderOf(TemplateHeader header) {
        return TemplateHeader.builderOf(header, header.getSerializer(), header.getBoundingBox());
    }

    public static Builder builderOf(TemplateHeader header, ResourceLocation serializer, Region boundingBox) {
        return TemplateHeader.builder(serializer, boundingBox).author(header.getAuthor()).name(header.getName()).requiredItems(header.getRequiredItems());
    }

    public static Builder builderFromNBT(CompoundNBT nbt) {
        Preconditions.checkArgument((nbt.func_150297_b("serializer", 8) && nbt.func_150297_b("bounds", 10) ? 1 : 0) != 0, (Object)"Cannot construct a TemplateHeader without 'serializer' and 'bounds'!");
        ResourceLocation serializer = new ResourceLocation(nbt.func_74779_i("serializer"));
        Region region = Region.deserializeFrom(nbt.func_74775_l("bounds"));
        Builder builder = TemplateHeader.builder(serializer, region);
        if (nbt.func_150297_b("name", 8)) {
            builder.name(nbt.func_74779_i("name"));
        }
        if (nbt.func_150297_b("author", 8)) {
            builder.name(nbt.func_74779_i("author"));
        }
        if (nbt.func_150297_b("materials", 10)) {
            builder.requiredItems(MaterialList.deserialize(nbt.func_74775_l("materials")));
        }
        return builder;
    }

    public static TemplateHeader fromNBT(CompoundNBT nbt) {
        return TemplateHeader.builderFromNBT(nbt).build();
    }

    private TemplateHeader(@Nullable String name, @Nullable String author, @Nullable MaterialList requiredItems, @Nonnull ResourceLocation serializer, @Nonnull Region boundingBox) {
        this.name = name;
        this.author = author;
        this.requiredItems = requiredItems;
        this.serializer = Objects.requireNonNull(serializer);
        this.boundingBox = Objects.requireNonNull(boundingBox);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Nullable
    public MaterialList getRequiredItems() {
        return this.requiredItems;
    }

    @Nonnull
    public ResourceLocation getSerializer() {
        return this.serializer;
    }

    @Nonnull
    public Region getBoundingBox() {
        return this.boundingBox;
    }

    public CompoundNBT toNBT(boolean persisted) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("serializer", this.getSerializer().toString());
        nbt.func_218657_a("bounds", (INBT)this.getBoundingBox().serialize());
        if (this.getName() != null) {
            nbt.func_74778_a("name", this.getName());
        }
        if (this.getAuthor() != null) {
            nbt.func_74778_a("author", this.getAuthor());
        }
        if (!persisted && this.getRequiredItems() != null) {
            nbt.func_218657_a("materials", (INBT)this.getRequiredItems().serialize(persisted));
        }
        return nbt;
    }

    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String author;
        @Nullable
        private MaterialList requiredItems;
        @Nonnull
        private final ResourceLocation serializer;
        @Nonnull
        private Region boundingBox;

        private Builder(ResourceLocation serializer, Region boundingBox) {
            this.serializer = Objects.requireNonNull(serializer);
            this.boundingBox = Objects.requireNonNull(boundingBox);
        }

        public Builder bounds(Region boundingBox) {
            this.boundingBox = Objects.requireNonNull(boundingBox);
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder author(@Nullable String author) {
            this.author = author;
            return this;
        }

        public Builder requiredItems(@Nullable MaterialList requiredItems) {
            this.requiredItems = requiredItems;
            return this;
        }

        public TemplateHeader build() {
            return new TemplateHeader(this.name, this.author, this.requiredItems, this.serializer, this.boundingBox);
        }
    }
}

