/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.building.tilesupport;

import com.direwolf20.buildinggadgets.api.Registries;
import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.tilesupport.ITileDataFactory;
import com.direwolf20.buildinggadgets.api.building.tilesupport.ITileDataProvider;
import com.direwolf20.buildinggadgets.api.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.api.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.api.serialisation.ITileDataSerializer;
import com.direwolf20.buildinggadgets.api.serialisation.SerialisationSupport;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public final class TileSupport {
    private static ITileDataFactory DATA_PROVIDER_FACTORY = new DataProviderFactory();
    private static final ITileEntityData DUMMY_TILE_ENTITY_DATA = new ITileEntityData(){

        @Override
        public ITileDataSerializer getSerializer() {
            return SerialisationSupport.dummyDataSerializer();
        }

        @Override
        public boolean placeIn(IBuildContext context, BlockState state, BlockPos position) {
            return context.getWorld().func_180501_a(position, state, 0);
        }
    };

    private TileSupport() {
    }

    public static ITileDataFactory dataProviderFactory() {
        return DATA_PROVIDER_FACTORY;
    }

    public static ITileEntityData createTileData(@Nullable TileEntity te) {
        if (te == null) {
            return TileSupport.dummyTileEntityData();
        }
        for (ITileDataFactory factory : Registries.TileEntityData.getTileDataFactories()) {
            ITileEntityData res = factory.createDataFor(te);
            if (res == null) continue;
            return res;
        }
        return TileSupport.dummyTileEntityData();
    }

    public static ITileEntityData createTileData(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return TileSupport.createTileData(te);
    }

    public static BlockData createBlockData(BlockState state, @Nullable TileEntity te) {
        return new BlockData(Objects.requireNonNull(state), TileSupport.createTileData(te));
    }

    public static BlockData createBlockData(IBlockReader world, BlockPos pos) {
        return new BlockData(world.func_180495_p(pos), TileSupport.createTileData(world, pos));
    }

    public static ITileEntityData dummyTileEntityData() {
        return DUMMY_TILE_ENTITY_DATA;
    }

    private static class DataProviderFactory
    implements ITileDataFactory {
        private DataProviderFactory() {
        }

        @Override
        @Nullable
        public ITileEntityData createDataFor(TileEntity tileEntity) {
            if (tileEntity instanceof ITileDataProvider) {
                return ((ITileDataProvider)tileEntity).createTileData();
            }
            return null;
        }
    }
}

