/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.building.placement;

import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.api.building.placement.PlacementSequences;
import com.direwolf20.buildinggadgets.api.util.MathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

final class GridSequence
implements IPositionPlacementSequence {
    private final int periodSize;
    private final Region region;
    private final BlockPos center;
    private final int range;

    @VisibleForTesting
    GridSequence(BlockPos center, int range, int periodSize) {
        this.region = PlacementSequences.Wall.clickedSide(center, Direction.UP, range).getBoundingBox();
        this.range = range;
        this.center = center;
        this.periodSize = periodSize;
    }

    @VisibleForTesting
    private GridSequence(Region region, BlockPos center, int range, int periodSize) {
        this.region = region;
        this.center = center;
        this.range = range;
        this.periodSize = periodSize;
    }

    @Override
    public Region getBoundingBox() {
        return this.region;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.region.contains(x, y, z);
    }

    @Override
    public IPositionPlacementSequence copy() {
        return new GridSequence(this.region, this.center, this.range, this.periodSize);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        final int period = (this.range - 1) % this.periodSize + 2;
        final int end = (this.range + 1) * 7 / 5;
        final int start = MathUtils.floorMultiple(-end, period);
        return new AbstractIterator<BlockPos>(){
            private int x;
            private int z;
            {
                this.x = start;
                this.z = start;
            }

            protected BlockPos computeNext() {
                if (this.z > end) {
                    return (BlockPos)this.endOfData();
                }
                BlockPos pos = new BlockPos(GridSequence.this.center.func_177958_n() + this.x, GridSequence.this.center.func_177956_o(), GridSequence.this.center.func_177952_p() + this.z);
                this.x += period;
                if (this.x > end) {
                    this.x = start;
                    this.z += period;
                }
                return pos;
            }
        };
    }
}

