/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.util;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.recipe.IAlloyFurnaceRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import org.apache.commons.io.FileUtils;

public class DatapackUtils {
    public static void generateAlloyFurnaceRecipe(IAlloyFurnaceRecipe recipe, String path) {
        String shortname = ((Ingredient)recipe.getRequiredItems().get(0)).func_193365_a()[0].func_77973_b().getRegistryName().func_110623_a() + recipe.func_77571_b().func_77973_b().getRegistryName().func_110623_a() + "_generated";
        JsonArray ingredientArray = new JsonArray();
        for (int i = 0; i < recipe.getRequiredItems().size(); ++i) {
            JsonObject ingredients = new JsonObject();
            ingredients.add("item", (JsonElement)new JsonPrimitive(((Ingredient)recipe.getRequiredItems().get(i)).func_193365_a()[0].func_77973_b().getRegistryName().toString()));
            ingredients.add("count", (JsonElement)new JsonPrimitive((Number)recipe.getRequiredCount().get(i)));
            ingredientArray.add((JsonElement)ingredients);
        }
        ItemStack outputItem = recipe.func_77571_b();
        JsonObject outitem = new JsonObject();
        outitem.add("item", (JsonElement)new JsonPrimitive(outputItem.func_77973_b().getRegistryName().toString()));
        outitem.add("count", (JsonElement)new JsonPrimitive((Number)outputItem.func_190916_E()));
        JsonObject json = new JsonObject();
        json.add("type", (JsonElement)new JsonPrimitive("bluepower:alloy_smelting"));
        json.add("ingredients", (JsonElement)ingredientArray);
        json.add("result", (JsonElement)outitem);
        File file = new File(path + "/bluepower/data/bluepower/recipes/alloy_furnace/" + shortname + ".json");
        try {
            if (file.createNewFile()) {
                BluePower.log.info("Created Json File: " + file.getPath());
            } else {
                BluePower.log.info("File already Exists: " + file.getPath());
            }
        }
        catch (IOException e) {
            BluePower.log.info("Creating file failed: " + file.getPath());
        }
        try {
            FileWriter fileWriter = new FileWriter(file.getPath());
            fileWriter.write(json.toString());
            fileWriter.close();
        }
        catch (IOException e) {
            BluePower.log.info("Editing File Failed: " + file.getPath());
        }
    }

    public static void clearBPAlloyFurnaceDatapack(String path) {
        try {
            FileUtils.cleanDirectory((File)new File(path + "/bluepower/data/bluepower/recipes/alloy_furnace"));
        }
        catch (Exception e) {
            BluePower.log.info("Failed to clean Alloy Furnace Recipe Folder");
        }
    }

    public static void createBPDatapack(String path) {
        File folder = new File(path + "/bluepower");
        if (folder.mkdir()) {
            BluePower.log.info("Created DataPack Folder: " + folder.getPath());
        } else {
            BluePower.log.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
        JsonObject pack = new JsonObject();
        pack.add("description", (JsonElement)new JsonPrimitive("bluepower resources"));
        pack.add("pack_format", (JsonElement)new JsonPrimitive((Number)4));
        JsonObject mcmeta = new JsonObject();
        mcmeta.add("pack", (JsonElement)pack);
        File file = new File(path + "/bluepower/pack.mcmeta");
        try {
            if (file.createNewFile()) {
                BluePower.log.info("Created Data Pack mcmeta: " + file.getPath());
            } else {
                BluePower.log.info("File already Exists: " + file.getPath());
            }
        }
        catch (IOException e) {
            BluePower.log.info("Creating file failed: " + file.getPath());
        }
        try {
            FileWriter fileWriter = new FileWriter(file.getPath());
            fileWriter.write(mcmeta.toString());
            fileWriter.close();
        }
        catch (IOException e) {
            BluePower.log.info("Editing File Failed: " + file.getPath());
        }
        folder = new File(path + "/bluepower/data");
        if (folder.mkdir()) {
            BluePower.log.info("Created DataPack Folder: " + folder.getPath());
        } else {
            BluePower.log.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
        folder = new File(path + "/bluepower/data/bluepower");
        if (folder.mkdir()) {
            BluePower.log.info("Created DataPack Folder: " + folder.getPath());
        } else {
            BluePower.log.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
        folder = new File(path + "/bluepower/data/bluepower/recipes");
        if (folder.mkdir()) {
            BluePower.log.info("Created DataPack Folder: " + folder.getPath());
        } else {
            BluePower.log.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
        folder = new File(path + "/bluepower/data/bluepower/recipes/alloy_furnace");
        if (folder.mkdir()) {
            BluePower.log.info("Created DataPack Folder: " + folder.getPath());
        } else {
            BluePower.log.info("DataPack Already Exists or Failed: " + folder.getPath());
        }
    }
}

