/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityFEStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.block.power.BlockEngine;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEngine
extends TileMachineBase {
    private Direction orientation;
    public boolean isActive = false;
    public byte pumpTick = 0;
    public byte pumpSpeed;
    private final BlutricityFEStorage storage = new BlutricityFEStorage(100.0){

        @Override
        public boolean canReceive() {
            return false;
        }
    };
    private LazyOptional<BlutricityFEStorage> blutricityCap;

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY || cap == CapabilityEnergy.ENERGY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return super.getCapability(cap);
    }

    public TileEngine() {
        super(BPTileEntityType.ENGINE);
        this.pumpSpeed = (byte)16;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            if (this.isActive) {
                this.pumpTick = (byte)(this.pumpTick + 1);
                if (this.pumpTick >= this.pumpSpeed * 2) {
                    this.pumpTick = 0;
                    if (this.pumpSpeed > 4) {
                        this.pumpSpeed = (byte)(this.pumpSpeed - 1);
                    }
                }
            } else {
                this.pumpTick = 0;
            }
        }
        this.storage.resetCurrent();
        boolean bl = this.isActive = this.storage.getEnergyStored() > 0 && this.field_145850_b.func_175640_z(this.field_174879_c);
        if ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEngine.ACTIVE) != this.isActive) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)BlockEngine.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)));
        }
    }

    public void setOrientation(Direction orientation) {
        this.orientation = orientation;
        this.func_70296_d();
    }

    public Direction getOrientation() {
        return this.orientation;
    }

    @Override
    protected void writeToPacketNBT(CompoundNBT compound) {
        super.writeToPacketNBT(compound);
        int rotation = this.orientation.func_176745_a();
        compound.func_74768_a("rotation", rotation);
        compound.func_74774_a("pumpspeed", this.pumpSpeed);
        compound.func_74774_a("pumptick", this.pumpTick);
        INBT nbtstorage = CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null);
        compound.func_218657_a("energy", nbtstorage);
    }

    @Override
    protected void readFromPacketNBT(CompoundNBT compound) {
        super.readFromPacketNBT(compound);
        this.orientation = Direction.func_82600_a((int)compound.func_74762_e("rotation"));
        this.pumpSpeed = compound.func_74771_c("pumpspeed");
        this.pumpTick = compound.func_74771_c("pumptick");
        if (compound.func_74764_b("energy")) {
            INBT nbtstorage = compound.func_74781_a("energy");
            CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null, nbtstorage);
        }
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

