/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.BluePower;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileBase;
import com.bluepowermod.tile.tier3.IRedBusWindow;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.block.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;

public class TileCPU
extends TileBase
implements IRedBusWindow {
    public int cpuStoredCycles = 100000;
    public int cpuForTickCycles = 1;
    public byte deviceID = 0;
    public byte screenID = 1;
    public byte discDriveID = (byte)2;
    public boolean halt = false;
    private byte[] memory = new byte[8192];
    private int programCounter;
    private int stackPointer;
    private int reg_X;
    private int reg_Y;
    private int reg_A;
    private int reg_B;
    private int reg_D;
    private int reg_I;
    private int reg_R;
    private boolean flag_C;
    private boolean flag_D;
    private boolean flag_E;
    private boolean flag_M;
    private boolean flag_N;
    private boolean flag_O;
    private boolean flag_X;
    private boolean flag_Z;
    private boolean flag_BRK;
    private boolean flag_WAI;
    private int redbus_remote_address;
    private boolean redbus_timeout;
    private boolean redbus_window_enabled = true;
    private Object redbus_cache;
    private int availableCycles;
    public int rtc = 0;
    private int effectiveAddress;
    private int BRKaddress;

    public TileCPU() {
        super(BPTileEntityType.CPU);
        this.powerOnReset();
    }

    public void powerOnReset() {
        this.programCounter = 1024;
        this.BRKaddress = 1024;
        this.stackPointer = 512;
        this.reg_R = 768;
        this.memory[0] = this.discDriveID;
        this.memory[1] = this.screenID;
        this.memory[2] = 0;
        this.reg_A = 0;
        this.reg_Y = 0;
        this.reg_A = 0;
        this.flag_BRK = false;
        boolean preloadRam = true;
        if (preloadRam) {
            this.preLoadRAM();
            return;
        }
        String bootLoader = "/assets/bluepower/software/rpcboot.bin";
        InputStream disc = BluePower.class.getResourceAsStream(bootLoader);
        if (disc == null) {
            BluePower.log.info("[BluePowerControl] CPU failed to load bootloader " + bootLoader);
            return;
        }
        try {
            BluePower.log.info("[BluePowerControl] CPU loaded bootloader " + bootLoader);
            disc.read(this.memory, 1024, 256);
            disc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void preLoadRAM() {
        this.memory[1024] = -37;
    }

    @Override
    public void func_73660_a() {
        if (this.halt) {
            return;
        }
        ++this.rtc;
        this.flag_WAI = false;
        this.redbus_timeout = false;
        this.availableCycles += this.cpuForTickCycles;
        if (this.availableCycles > this.cpuStoredCycles) {
            this.availableCycles = this.cpuStoredCycles;
        }
        while (this.availableCycles > 0 && !this.flag_WAI && !this.redbus_timeout) {
            this.executeInstruction();
        }
    }

    private void dumpMemory() {
        if (this.programCounter > this.memory.length) {
            this.availableCycles = -1;
            this.halt = true;
            return;
        }
        --this.availableCycles;
        String message = "[BluePowerControl] " + this.programCounter + ": ";
        for (int i = 0; i < 16; ++i) {
            message = message + Integer.toHexString(this.readMemory(this.programCounter) & 0xFF) + " ";
            ++this.programCounter;
        }
        BluePower.log.info(message);
        --this.availableCycles;
    }

    private void executeInstruction() {
        --this.availableCycles;
        int opcode = this.readMemory(this.programCounter);
        BluePower.log.info("[BluePowerControl] CPU " + Integer.toHexString(this.programCounter) + ":" + Integer.toHexString(opcode));
        ++this.programCounter;
        switch (opcode) {
            case 0: {
                this.opBRK();
                break;
            }
            case 1: {
                this.invalid(opcode);
                break;
            }
            case 2: {
                this.invalid(opcode);
                break;
            }
            case 3: {
                this.invalid(opcode);
                break;
            }
            case 4: {
                this.invalid(opcode);
                break;
            }
            case 5: {
                this.invalid(opcode);
                break;
            }
            case 6: {
                this.invalid(opcode);
                break;
            }
            case 7: {
                this.invalid(opcode);
                break;
            }
            case 8: {
                this.invalid(opcode);
                break;
            }
            case 9: {
                this.invalid(opcode);
                break;
            }
            case 10: {
                this.invalid(opcode);
                break;
            }
            case 11: {
                this.invalid(opcode);
                break;
            }
            case 12: {
                this.invalid(opcode);
                break;
            }
            case 13: {
                this.invalid(opcode);
                break;
            }
            case 14: {
                this.invalid(opcode);
                break;
            }
            case 15: {
                this.invalid(opcode);
                break;
            }
            case 16: {
                this.invalid(opcode);
                break;
            }
            case 17: {
                this.invalid(opcode);
                break;
            }
            case 18: {
                this.invalid(opcode);
                break;
            }
            case 19: {
                this.invalid(opcode);
                break;
            }
            case 20: {
                this.invalid(opcode);
                break;
            }
            case 21: {
                this.invalid(opcode);
                break;
            }
            case 22: {
                this.invalid(opcode);
                break;
            }
            case 23: {
                this.invalid(opcode);
                break;
            }
            case 24: {
                this.opCLC();
                break;
            }
            case 25: {
                this.invalid(opcode);
                break;
            }
            case 26: {
                this.opINC(this.reg_A);
                break;
            }
            case 27: {
                this.invalid(opcode);
                break;
            }
            case 28: {
                this.invalid(opcode);
                break;
            }
            case 29: {
                this.invalid(opcode);
                break;
            }
            case 30: {
                this.invalid(opcode);
                break;
            }
            case 31: {
                this.invalid(opcode);
                break;
            }
            case 32: {
                this.invalid(opcode);
                break;
            }
            case 33: {
                this.invalid(opcode);
                break;
            }
            case 34: {
                this.invalid(opcode);
                break;
            }
            case 35: {
                this.invalid(opcode);
                break;
            }
            case 36: {
                this.opBIT();
                break;
            }
            case 37: {
                this.invalid(opcode);
                break;
            }
            case 38: {
                this.invalid(opcode);
                break;
            }
            case 39: {
                this.invalid(opcode);
                break;
            }
            case 40: {
                this.invalid(opcode);
                break;
            }
            case 41: {
                this.invalid(opcode);
                break;
            }
            case 42: {
                this.invalid(opcode);
                break;
            }
            case 43: {
                this.invalid(opcode);
                break;
            }
            case 44: {
                this.opBIT();
                break;
            }
            case 45: {
                this.invalid(opcode);
                break;
            }
            case 46: {
                this.invalid(opcode);
                break;
            }
            case 47: {
                this.invalid(opcode);
                break;
            }
            case 48: {
                this.invalid(opcode);
                break;
            }
            case 49: {
                this.invalid(opcode);
                break;
            }
            case 50: {
                this.invalid(opcode);
                break;
            }
            case 51: {
                this.invalid(opcode);
                break;
            }
            case 52: {
                this.invalid(opcode);
                break;
            }
            case 53: {
                this.invalid(opcode);
                break;
            }
            case 54: {
                this.invalid(opcode);
                break;
            }
            case 55: {
                this.invalid(opcode);
                break;
            }
            case 56: {
                this.flag_C = true;
                break;
            }
            case 57: {
                this.invalid(opcode);
                break;
            }
            case 58: {
                this.opDEC(this.reg_A);
                break;
            }
            case 59: {
                this.invalid(opcode);
                break;
            }
            case 60: {
                this.invalid(opcode);
                break;
            }
            case 61: {
                this.invalid(opcode);
                break;
            }
            case 62: {
                this.invalid(opcode);
                break;
            }
            case 63: {
                this.invalid(opcode);
                break;
            }
            case 64: {
                this.invalid(opcode);
                break;
            }
            case 65: {
                this.invalid(opcode);
                break;
            }
            case 66: {
                this.invalid(opcode);
                break;
            }
            case 67: {
                this.invalid(opcode);
                break;
            }
            case 68: {
                this.invalid(opcode);
                break;
            }
            case 69: {
                this.invalid(opcode);
                break;
            }
            case 70: {
                this.invalid(opcode);
                break;
            }
            case 71: {
                this.invalid(opcode);
                break;
            }
            case 72: {
                this.invalid(opcode);
                break;
            }
            case 73: {
                this.invalid(opcode);
                break;
            }
            case 74: {
                this.invalid(opcode);
                break;
            }
            case 75: {
                this.invalid(opcode);
                break;
            }
            case 76: {
                this.invalid(opcode);
                break;
            }
            case 77: {
                this.invalid(opcode);
                break;
            }
            case 78: {
                this.invalid(opcode);
                break;
            }
            case 79: {
                this.invalid(opcode);
                break;
            }
            case 80: {
                this.invalid(opcode);
                break;
            }
            case 81: {
                this.invalid(opcode);
                break;
            }
            case 82: {
                this.invalid(opcode);
                break;
            }
            case 83: {
                this.invalid(opcode);
                break;
            }
            case 84: {
                this.invalid(opcode);
                break;
            }
            case 85: {
                this.invalid(opcode);
                break;
            }
            case 86: {
                this.invalid(opcode);
                break;
            }
            case 87: {
                this.invalid(opcode);
                break;
            }
            case 88: {
                this.invalid(opcode);
                break;
            }
            case 89: {
                this.invalid(opcode);
                break;
            }
            case 90: {
                this.invalid(opcode);
                break;
            }
            case 91: {
                this.invalid(opcode);
                break;
            }
            case 92: {
                this.opTXI();
                break;
            }
            case 93: {
                this.invalid(opcode);
                break;
            }
            case 94: {
                this.invalid(opcode);
                break;
            }
            case 95: {
                this.invalid(opcode);
                break;
            }
            case 96: {
                this.invalid(opcode);
                break;
            }
            case 97: {
                this.invalid(opcode);
                break;
            }
            case 98: {
                this.invalid(opcode);
                break;
            }
            case 99: {
                this.invalid(opcode);
                break;
            }
            case 100: {
                this.invalid(opcode);
                break;
            }
            case 101: {
                this.invalid(opcode);
                break;
            }
            case 102: {
                this.invalid(opcode);
                break;
            }
            case 103: {
                this.invalid(opcode);
                break;
            }
            case 104: {
                this.invalid(opcode);
                break;
            }
            case 105: {
                this.invalid(opcode);
                break;
            }
            case 106: {
                this.invalid(opcode);
                break;
            }
            case 107: {
                this.invalid(opcode);
                break;
            }
            case 108: {
                this.invalid(opcode);
                break;
            }
            case 109: {
                this.invalid(opcode);
                break;
            }
            case 110: {
                this.invalid(opcode);
                break;
            }
            case 111: {
                this.invalid(opcode);
                break;
            }
            case 112: {
                this.invalid(opcode);
                break;
            }
            case 113: {
                this.invalid(opcode);
                break;
            }
            case 114: {
                this.invalid(opcode);
                break;
            }
            case 115: {
                this.invalid(opcode);
                break;
            }
            case 116: {
                this.invalid(opcode);
                break;
            }
            case 117: {
                this.invalid(opcode);
                break;
            }
            case 118: {
                this.invalid(opcode);
                break;
            }
            case 119: {
                this.invalid(opcode);
                break;
            }
            case 120: {
                this.invalid(opcode);
                break;
            }
            case 121: {
                this.invalid(opcode);
                break;
            }
            case 122: {
                this.invalid(opcode);
                break;
            }
            case 123: {
                this.invalid(opcode);
                break;
            }
            case 124: {
                this.invalid(opcode);
                break;
            }
            case 125: {
                this.invalid(opcode);
                break;
            }
            case 126: {
                this.invalid(opcode);
                break;
            }
            case 127: {
                this.invalid(opcode);
                break;
            }
            case 128: {
                this.invalid(opcode);
                break;
            }
            case 129: {
                this.invalid(opcode);
                break;
            }
            case 130: {
                this.invalid(opcode);
                break;
            }
            case 131: {
                this.invalid(opcode);
                break;
            }
            case 132: {
                this.invalid(opcode);
                break;
            }
            case 133: {
                this.invalid(opcode);
                break;
            }
            case 134: {
                this.invalid(opcode);
                break;
            }
            case 135: {
                this.invalid(opcode);
                break;
            }
            case 136: {
                this.invalid(opcode);
                break;
            }
            case 137: {
                this.invalid(opcode);
                break;
            }
            case 138: {
                this.opTXA();
                break;
            }
            case 139: {
                this.opTXR();
                break;
            }
            case 140: {
                this.invalid(opcode);
                break;
            }
            case 141: {
                this.invalid(opcode);
                break;
            }
            case 142: {
                this.invalid(opcode);
                break;
            }
            case 143: {
                this.opTXR();
                break;
            }
            case 144: {
                this.invalid(opcode);
                break;
            }
            case 145: {
                this.invalid(opcode);
                break;
            }
            case 146: {
                this.invalid(opcode);
                break;
            }
            case 147: {
                this.invalid(opcode);
                break;
            }
            case 148: {
                this.invalid(opcode);
                break;
            }
            case 149: {
                this.invalid(opcode);
                break;
            }
            case 150: {
                this.invalid(opcode);
                break;
            }
            case 151: {
                this.invalid(opcode);
                break;
            }
            case 152: {
                this.opTYA();
                break;
            }
            case 153: {
                this.invalid(opcode);
                break;
            }
            case 154: {
                this.opTXS();
                break;
            }
            case 155: {
                this.opTXY();
                break;
            }
            case 156: {
                this.invalid(opcode);
                break;
            }
            case 157: {
                this.invalid(opcode);
                break;
            }
            case 158: {
                this.invalid(opcode);
                break;
            }
            case 159: {
                this.invalid(opcode);
                break;
            }
            case 160: {
                this.invalid(opcode);
                break;
            }
            case 161: {
                this.invalid(opcode);
                break;
            }
            case 162: {
                this.invalid(opcode);
                break;
            }
            case 163: {
                this.invalid(opcode);
                break;
            }
            case 164: {
                this.invalid(opcode);
                break;
            }
            case 165: {
                this.opLDA();
                break;
            }
            case 166: {
                this.invalid(opcode);
                break;
            }
            case 167: {
                this.invalid(opcode);
                break;
            }
            case 168: {
                this.opTAY();
                break;
            }
            case 169: {
                this.invalid(opcode);
                break;
            }
            case 170: {
                this.opTAY();
                break;
            }
            case 171: {
                this.opTRX();
                break;
            }
            case 172: {
                this.invalid(opcode);
                break;
            }
            case 173: {
                this.invalid(opcode);
                break;
            }
            case 174: {
                this.invalid(opcode);
                break;
            }
            case 175: {
                this.opTDA();
                break;
            }
            case 176: {
                this.invalid(opcode);
                break;
            }
            case 177: {
                this.invalid(opcode);
                break;
            }
            case 178: {
                this.invalid(opcode);
                break;
            }
            case 179: {
                this.invalid(opcode);
                break;
            }
            case 180: {
                this.invalid(opcode);
                break;
            }
            case 181: {
                this.invalid(opcode);
                break;
            }
            case 182: {
                this.invalid(opcode);
                break;
            }
            case 183: {
                this.invalid(opcode);
                break;
            }
            case 184: {
                this.invalid(opcode);
                break;
            }
            case 185: {
                this.invalid(opcode);
                break;
            }
            case 186: {
                this.opTSX();
                break;
            }
            case 187: {
                this.opTYX();
                break;
            }
            case 188: {
                this.invalid(opcode);
                break;
            }
            case 189: {
                this.invalid(opcode);
                break;
            }
            case 190: {
                this.invalid(opcode);
                break;
            }
            case 191: {
                this.opTAD();
                break;
            }
            case 192: {
                this.invalid(opcode);
                break;
            }
            case 193: {
                this.invalid(opcode);
                break;
            }
            case 194: {
                this.opREP();
                break;
            }
            case 195: {
                this.invalid(opcode);
                break;
            }
            case 196: {
                this.invalid(opcode);
                break;
            }
            case 197: {
                this.invalid(opcode);
                break;
            }
            case 198: {
                this.opDEC(this.decodeMemoryMode(AddressMode.ZEROPAGE));
                break;
            }
            case 199: {
                this.invalid(opcode);
                break;
            }
            case 200: {
                this.invalid(opcode);
                break;
            }
            case 201: {
                this.invalid(opcode);
                break;
            }
            case 202: {
                this.invalid(opcode);
                break;
            }
            case 203: {
                this.opWAI();
                break;
            }
            case 204: {
                this.invalid(opcode);
                break;
            }
            case 205: {
                this.invalid(opcode);
                break;
            }
            case 206: {
                this.opDEC(this.decodeMemoryMode(AddressMode.ABSOLUTE));
                break;
            }
            case 207: {
                this.invalid(opcode);
                break;
            }
            case 208: {
                this.invalid(opcode);
                break;
            }
            case 209: {
                this.invalid(opcode);
                break;
            }
            case 210: {
                this.invalid(opcode);
                break;
            }
            case 211: {
                this.invalid(opcode);
                break;
            }
            case 212: {
                this.invalid(opcode);
                break;
            }
            case 213: {
                this.invalid(opcode);
                break;
            }
            case 214: {
                this.opDEC(this.decodeMemoryMode(AddressMode.ZEROPAGE, this.reg_X));
                break;
            }
            case 215: {
                this.invalid(opcode);
                break;
            }
            case 216: {
                this.invalid(opcode);
                break;
            }
            case 217: {
                this.invalid(opcode);
                break;
            }
            case 218: {
                this.invalid(opcode);
                break;
            }
            case 219: {
                this.opSTP();
                break;
            }
            case 220: {
                this.opTIX();
                break;
            }
            case 221: {
                this.invalid(opcode);
                break;
            }
            case 222: {
                this.opDEC(this.decodeMemoryMode(AddressMode.ABSOLUTE, this.reg_X));
                break;
            }
            case 223: {
                this.invalid(opcode);
                break;
            }
            case 224: {
                this.invalid(opcode);
                break;
            }
            case 225: {
                this.invalid(opcode);
                break;
            }
            case 226: {
                this.invalid(opcode);
                break;
            }
            case 227: {
                this.invalid(opcode);
                break;
            }
            case 228: {
                this.invalid(opcode);
                break;
            }
            case 229: {
                this.invalid(opcode);
                break;
            }
            case 230: {
                this.opINC(this.decodeMemoryMode(AddressMode.ZEROPAGE));
                break;
            }
            case 231: {
                this.invalid(opcode);
                break;
            }
            case 232: {
                this.invalid(opcode);
                break;
            }
            case 233: {
                this.invalid(opcode);
                break;
            }
            case 234: {
                break;
            }
            case 235: {
                this.invalid(opcode);
                break;
            }
            case 236: {
                this.invalid(opcode);
                break;
            }
            case 237: {
                this.invalid(opcode);
                break;
            }
            case 238: {
                this.opINC(this.decodeMemoryMode(AddressMode.ABSOLUTE));
                break;
            }
            case 239: {
                this.opMMU(this.readMemory(this.programCounter));
                break;
            }
            case 240: {
                this.invalid(opcode);
                break;
            }
            case 241: {
                this.invalid(opcode);
                break;
            }
            case 242: {
                this.invalid(opcode);
                break;
            }
            case 243: {
                this.invalid(opcode);
                break;
            }
            case 244: {
                this.invalid(opcode);
                break;
            }
            case 245: {
                this.invalid(opcode);
                break;
            }
            case 246: {
                this.opINC(this.decodeMemoryMode(AddressMode.ZEROPAGE, this.reg_X));
                break;
            }
            case 247: {
                this.invalid(opcode);
                break;
            }
            case 248: {
                this.invalid(opcode);
                break;
            }
            case 249: {
                this.invalid(opcode);
                break;
            }
            case 250: {
                this.invalid(opcode);
                break;
            }
            case 251: {
                this.opXCE();
                break;
            }
            case 252: {
                this.invalid(opcode);
                break;
            }
            case 253: {
                this.invalid(opcode);
                break;
            }
            case 254: {
                this.opINC(this.decodeMemoryMode(AddressMode.ABSOLUTE, this.reg_X));
                break;
            }
            case 255: {
                this.invalid(opcode);
            }
        }
    }

    private void opREP() {
        this.setFlags(this.getFlags() & ~this.readMemory(this.programCounter));
    }

    private void opTYX() {
        this.reg_X = this.reg_Y;
    }

    private void opTXY() {
        this.reg_Y = this.reg_X;
    }

    public void opSTP() {
        this.availableCycles = -1;
        this.halt = true;
        BluePower.log.info("self block=" + this.func_200662_C());
        if (this.field_145850_b.func_175623_d(this.field_174879_c)) {
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f, true);
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public void opTRX() {
        this.reg_X = this.reg_R;
    }

    public void opTXR() {
        this.reg_R = this.reg_X;
    }

    public void opTAD() {
        this.reg_D = this.reg_A;
    }

    public void opTDA() {
        this.reg_A = this.reg_D;
    }

    public void opTIX() {
        this.reg_X = this.reg_I;
    }

    public void opTXI() {
        this.reg_I = this.reg_X;
    }

    public void opMMU(int mode) {
        ++this.programCounter;
        switch (mode) {
            case 0: {
                int t = this.reg_A & 0xFF;
                if (t == this.redbus_remote_address) break;
                if (this.redbus_cache != null) {
                    this.redbus_timeout = true;
                }
                this.redbus_remote_address = t;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.redbus_window_enabled = true;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 128: {
                this.reg_A = this.redbus_remote_address;
                break;
            }
            case 129: {
                break;
            }
            case 130: {
                this.redbus_window_enabled = false;
                break;
            }
            case 131: {
                break;
            }
            case 132: {
                break;
            }
            case 133: {
                break;
            }
            case 134: {
                break;
            }
            case 135: {
                this.reg_A = this.rtc & 0xFFFF;
                this.reg_D = this.rtc >> 16 & 0xFFFF;
                break;
            }
        }
    }

    private void opBRK() {
        this.flag_BRK = true;
        this.programCounter = this.BRKaddress;
    }

    private void opXCE() {
        boolean temp = this.flag_C;
        this.flag_E = this.flag_C;
        this.flag_C = temp;
    }

    private void opLDA() {
        this.reg_A = this.readMemory(this.effectiveAddress);
        ++this.programCounter;
    }

    private void opWAI() {
        this.flag_WAI = true;
    }

    private void opBIT() {
        int tmp = this.readMemory(this.programCounter + this.effectiveAddress);
        this.flag_Z = (this.reg_A & tmp) == 0;
        this.flag_N = (tmp & 0x80) != 0;
        this.flag_O = (tmp & 0x40) != 0;
    }

    private void opCLC() {
        this.flag_C = false;
    }

    private void opTAX() {
        this.reg_X = this.reg_A;
    }

    private void opTXA() {
        this.reg_A = this.reg_X;
    }

    private void opTAY() {
        this.reg_Y = this.reg_A;
    }

    private void opTYA() {
        this.reg_A = this.reg_Y;
    }

    private void opTSX() {
        this.reg_X = this.stackPointer;
    }

    private void opTXS() {
        this.stackPointer = this.reg_X;
    }

    private void opINC(int pc) {
        int i = this.readMemory(pc);
        i = i + 1 & this.maskMemory();
        this.writeMemory(pc, i);
        this.setArithmeticFlags(i);
    }

    private void opDEC(int pc) {
        int i = this.readMemory(pc);
        i = i - 1 & this.maskMemory();
        this.writeMemory(pc, i);
        this.setArithmeticFlags(i);
    }

    private void setArithmeticFlags(int reg) {
        this.flag_Z = reg == 0;
        this.flag_N = (reg & 0x80) != 0;
    }

    private int readMemory(int pc) {
        if (pc < this.memory.length) {
            return this.memory[pc] & 0xFF;
        }
        return 0;
    }

    private void writeMemory(int pc, int data) {
        if (pc < this.memory.length) {
            this.memory[pc] = (byte)(data & 0xFF);
            return;
        }
    }

    private int maskMemory() {
        if (this.flag_M) {
            return 255;
        }
        return 65535;
    }

    private int decodeMemoryMode(AddressMode mode) {
        int baseAddress = 0;
        int localAddress = this.readMemory(this.programCounter);
        switch (mode) {
            case ABSOLUTE: {
                baseAddress = this.sixteenBitAddress(localAddress, this.readMemory(this.programCounter++));
                break;
            }
            case INDIRECT: {
                baseAddress = this.readMemory(this.sixteenBitAddress(localAddress, this.readMemory(this.programCounter++)));
                break;
            }
            case RELATIVE: {
                baseAddress = this.programCounter - 129;
                break;
            }
            case ZEROPAGE: {
                baseAddress = 0 + (localAddress & 0xFF);
                ++this.programCounter;
                break;
            }
        }
        return baseAddress;
    }

    private int decodeMemoryMode(AddressMode mode, int offset) {
        int baseAddress = 0;
        int localAddress = this.readMemory(this.programCounter);
        switch (mode) {
            case ABSOLUTE: {
                baseAddress = this.sixteenBitAddress(localAddress, this.readMemory(this.programCounter++)) + offset;
                break;
            }
            case INDIRECT: {
                break;
            }
            case ZEROPAGE: {
                baseAddress = 0 + (localAddress + offset) & 0xFF;
                ++this.programCounter;
                break;
            }
        }
        return baseAddress;
    }

    int sixteenBitAddress(int lowByte, int hiByte) {
        return (hiByte << 8 | lowByte) & 0xFFFF;
    }

    private void setFlags(int flag) {
    }

    private int getFlags() {
        return 0;
    }

    private void invalid(int op) {
        this.halt = true;
        BluePower.log.error("BluePower CPU, Invalid OP code:" + Integer.toHexString(op));
    }

    public static enum AddressMode {
        ABSOLUTE,
        INDIRECT,
        RELATIVE,
        ZEROPAGE;

    }
}

