/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.client.render.BPBlockColor;
import com.bluepowermod.client.render.BPItemColor;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.client.render.IBPColoredItem;
import com.bluepowermod.client.render.ICustomModelBlock;
import com.bluepowermod.client.render.RenderEngine;
import com.bluepowermod.client.render.RenderLamp;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.tile.tier1.TileLamp;
import com.bluepowermod.tile.tier3.TileEngine;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class Renderers {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent evt) {
        for (Block block : BPBlocks.blockList) {
            if (!(block instanceof ICustomModelBlock)) continue;
            Renderers.registerBakedModel(block);
        }
    }

    @SubscribeEvent
    public void onTextureEvent(TextureStitchEvent.Pre event) {
        event.addSprite(new ResourceLocation("bluepower:blocks/models/engineoff"));
        event.addSprite(new ResourceLocation("bluepower:blocks/models/engineon"));
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        IUnbakedModel gliderModel;
        IUnbakedModel gearModel;
        IUnbakedModel baseModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("bluepower:block/engine/engine_base.obj"));
        if (baseModel instanceof OBJModel) {
            IBakedModel bakedModel = baseModel.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)new BasicState((IModelState)ForgeBlockStateV1.Transforms.get((String)"forge:default-block").get(), false), DefaultVertexFormats.field_176599_b);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "inventory"), bakedModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=false,facing=down,gear=false,glider=false"), bakedModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=true,facing=down,gear=false,glider=false"), bakedModel);
            bakedModel = baseModel.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)new BasicState((IModelState)ModelRotation.X180_Y0, false), DefaultVertexFormats.field_176599_b);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=false,facing=up,gear=false,glider=false"), bakedModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=true,facing=up,gear=false,glider=false"), bakedModel);
            bakedModel = baseModel.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)new BasicState((IModelState)ModelRotation.X270_Y90, false), DefaultVertexFormats.field_176599_b);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=false,facing=east,gear=false,glider=false"), bakedModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=true,facing=east,gear=false,glider=false"), bakedModel);
            bakedModel = baseModel.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)new BasicState((IModelState)ModelRotation.X90_Y90, false), DefaultVertexFormats.field_176599_b);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=false,facing=west,gear=false,glider=false"), bakedModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=true,facing=west,gear=false,glider=false"), bakedModel);
            bakedModel = baseModel.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)new BasicState((IModelState)ModelRotation.X270_Y0, false), DefaultVertexFormats.field_176599_b);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=false,facing=north,gear=false,glider=false"), bakedModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=true,facing=north,gear=false,glider=false"), bakedModel);
            bakedModel = baseModel.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)new BasicState((IModelState)ModelRotation.X90_Y0, false), DefaultVertexFormats.field_176599_b);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=false,facing=south,gear=false,glider=false"), bakedModel);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=true,facing=south,gear=false,glider=false"), bakedModel);
        }
        if ((gearModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("bluepower:block/engine/engine_gear.obj"))) instanceof OBJModel) {
            IBakedModel bakedModel = gearModel.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)new BasicState(gearModel.getDefaultState(), false), DefaultVertexFormats.field_176599_b);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=false,facing=down,gear=true,glider=false"), bakedModel);
        }
        if ((gliderModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("bluepower:block/engine/engine_glider.obj"))) instanceof OBJModel) {
            IBakedModel bakedModel = gliderModel.bake((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)new BasicState(gliderModel.getDefaultState(), false), DefaultVertexFormats.field_176599_b);
            event.getModelRegistry().put(new ModelResourceLocation("bluepower:engine", "active=false,facing=down,gear=false,glider=true"), bakedModel);
        }
    }

    public static void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileLamp.class, (TileEntityRenderer)new RenderLamp());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngine.class, (TileEntityRenderer)new RenderEngine());
        for (Item item : BPItems.itemList) {
            if (!(item instanceof IBPColoredItem)) continue;
            Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new BPItemColor(), new IItemProvider[]{item});
        }
        for (Block block : BPBlocks.blockList) {
            if (!(block instanceof IBPColoredBlock)) continue;
            Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BPBlockColor(), new Block[]{block});
            Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new BPBlockColor(), new IItemProvider[]{Item.func_150898_a((Block)block)});
        }
    }

    public static void registerBakedModel(Block block) {
        ((ICustomModelBlock)block).initModel();
    }
}

