/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.power;

import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.tile.tier3.TileBlulectricCable;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockBlulectricCable
extends BlockContainerBase {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty CONNECTED_FRONT = BooleanProperty.func_177716_a((String)"connected_front");
    public static final BooleanProperty CONNECTED_BACK = BooleanProperty.func_177716_a((String)"connected_back");
    public static final BooleanProperty CONNECTED_LEFT = BooleanProperty.func_177716_a((String)"connected_left");
    public static final BooleanProperty CONNECTED_RIGHT = BooleanProperty.func_177716_a((String)"connected_right");
    protected final VoxelShape[] shapes = this.makeShapes();

    public BlockBlulectricCable() {
        super(Material.field_151573_f, TileBlulectricCable.class);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)CONNECTED_FRONT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_BACK, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("bluepower:blulectric_cable");
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_200132_m();
    }

    protected VoxelShape[] makeShapes() {
        float width = 2.0f;
        float gap = 0.0f;
        float height = 2.0f;
        float f = 8.0f - width;
        float f1 = 8.0f + width;
        float f2 = 8.0f - width;
        float f3 = 8.0f + width;
        VoxelShape voxelshape = Block.func_208617_a((double)f, (double)0.0, (double)f, (double)f1, (double)height, (double)f1);
        VoxelShape voxelshape1 = Block.func_208617_a((double)f2, (double)gap, (double)0.0, (double)f3, (double)height, (double)f3);
        VoxelShape voxelshape2 = Block.func_208617_a((double)f2, (double)gap, (double)f2, (double)f3, (double)height, (double)16.0);
        VoxelShape voxelshape3 = Block.func_208617_a((double)0.0, (double)gap, (double)f2, (double)f3, (double)height, (double)f3);
        VoxelShape voxelshape4 = Block.func_208617_a((double)f2, (double)gap, (double)f2, (double)16.0, (double)height, (double)f3);
        VoxelShape voxelshape5 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{VoxelShapes.func_197880_a(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    private int getShapeIndex(BlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_FRONT)).booleanValue()) {
            i |= BlockBlulectricCable.getMask(Direction.NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_BACK)).booleanValue()) {
            i |= BlockBlulectricCable.getMask(Direction.SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_LEFT)).booleanValue()) {
            i |= BlockBlulectricCable.getMask(Direction.WEST);
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_RIGHT)).booleanValue()) {
            i |= BlockBlulectricCable.getMask(Direction.EAST);
        }
        return i;
    }

    private static int getMask(Direction facing) {
        return 1 << facing.func_176736_b();
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        if (!world.field_72995_K) {
            world.func_180501_a(pos, this.getStateForPos(world, pos), 2);
        }
        if (!world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_200132_m()) {
            world.func_175655_b(pos, true);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, CONNECTED_FRONT, CONNECTED_BACK, CONNECTED_LEFT, CONNECTED_RIGHT});
    }

    private BlockState getStateForPos(World world, BlockPos pos) {
        boolean connected_back = false;
        boolean connected_front = false;
        boolean connected_left = false;
        boolean connected_right = false;
        for (Direction face : FACING.func_177700_c()) {
            TileEntity tile = world.func_175625_s(pos.func_177972_a(face));
            if (tile == null) continue;
            switch (face) {
                case NORTH: {
                    connected_front = tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY).isPresent();
                    break;
                }
                case SOUTH: {
                    connected_back = tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY).isPresent();
                    break;
                }
                case WEST: {
                    connected_left = tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY).isPresent();
                    break;
                }
                case EAST: {
                    connected_right = tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY).isPresent();
                }
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(connected_right))).func_206870_a((IProperty)CONNECTED_LEFT, (Comparable)Boolean.valueOf(connected_left))).func_206870_a((IProperty)CONNECTED_FRONT, (Comparable)Boolean.valueOf(connected_front))).func_206870_a((IProperty)CONNECTED_BACK, (Comparable)Boolean.valueOf(connected_back));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPos(context.func_195991_k(), context.func_195995_a());
    }
}

