/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import net.kaneka.planttech2.items.upgradeable.BaseUpgradeableItem;
import net.kaneka.planttech2.items.upgradeable.UpgradeableHandItem;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class RangedWeaponItem
extends UpgradeableHandItem {
    public RangedWeaponItem(String name, Item.Properties property, int basecapacity, int maxInvSize) {
        super(name, property, basecapacity, maxInvSize, 0.0f, 2.4f);
        this.func_185043_a(new ResourceLocation("pull"), (stack, world, entity) -> {
            if (entity == null) {
                return 0.0f;
            }
            return !(entity.func_184607_cu().func_77973_b() instanceof RangedWeaponItem) ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f;
        });
        this.func_185043_a(new ResourceLocation("pulling"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
    }

    protected ItemStack findAmmo(PlayerEntity player) {
        if (this.isArrow(player.func_184586_b(Hand.OFF_HAND))) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (this.isArrow(player.func_184586_b(Hand.MAIN_HAND))) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isArrow(ItemStack stack) {
        return stack.func_77973_b() instanceof ArrowItem;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity PlayerEntity2 = (PlayerEntity)entityLiving;
            boolean flag = PlayerEntity2.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.findAmmo(PlayerEntity2);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)PlayerEntity2, (int)i, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                float f;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                if (!((double)(f = RangedWeaponItem.getArrowVelocity(i)) < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = PlayerEntity2.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ArrowItem && ((ArrowItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, PlayerEntity2);
                    if (!worldIn.field_72995_K) {
                        int k;
                        int j;
                        ArrowItem itemarrow = (ArrowItem)(itemstack.func_77973_b() instanceof ArrowItem ? itemstack.func_77973_b() : Items.field_151032_g);
                        AbstractArrowEntity entityarrow = itemarrow.func_200887_a(worldIn, itemstack, (LivingEntity)PlayerEntity2);
                        entityarrow = this.customizeArrow(entityarrow);
                        entityarrow.func_184547_a((Entity)PlayerEntity2, PlayerEntity2.field_70125_A, PlayerEntity2.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        if (f == 1.0f) {
                            entityarrow.func_70243_d(true);
                        }
                        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            entityarrow.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            entityarrow.func_70015_d(100);
                        }
                        if (!PlayerEntity2.func_184812_l_()) {
                            this.extractEnergy(stack, RangedWeaponItem.getEnergyCost(stack), false);
                        }
                        if (flag1 || PlayerEntity2.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                            entityarrow.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_217376_c((Entity)entityarrow);
                        this.extractEnergy(stack, RangedWeaponItem.getEnergyCost(stack), false);
                    }
                    worldIn.func_184148_a((PlayerEntity)null, PlayerEntity2.field_70165_t, PlayerEntity2.field_70163_u, PlayerEntity2.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !PlayerEntity2.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            PlayerEntity2.field_71071_by.func_184437_d(itemstack);
                        }
                    }
                }
            }
        }
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            System.out.println(RangedWeaponItem.getEnergyCost(stack));
            if (this.extractEnergy(stack, RangedWeaponItem.getEnergyCost(stack), true) >= RangedWeaponItem.getEnergyCost(stack)) {
                boolean flag = !this.findAmmo(player).func_190926_b();
                ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)worldIn, (PlayerEntity)player, (Hand)hand, (boolean)flag);
                if (ret != null) {
                    return ret;
                }
                if (!player.field_71075_bZ.field_75098_d && !flag) {
                    return flag ? new ActionResult(ActionResultType.PASS, (Object)stack) : new ActionResult(ActionResultType.FAIL, (Object)stack);
                }
                player.func_184598_c(hand);
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
        } else if (!worldIn.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new BaseUpgradeableItem.NamedContainerProvider(stack), buffer -> buffer.func_150788_a(stack));
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public AbstractArrowEntity customizeArrow(AbstractArrowEntity arrow) {
        return arrow;
    }
}

