/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.items.BaseItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class BiomassContainerItem
extends BaseItem {
    private static int capacity = 1000;

    public BiomassContainerItem() {
        super("biomasscontainer", new Item.Properties().func_200916_a(ModCreativeTabs.groupmain).func_200917_a(1));
        this.func_185043_a(new ResourceLocation("filled"), (stack, world, player) -> BiomassContainerItem.getFillLevelModel(stack));
    }

    public static float getFillLevelModel(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            int biomass = nbt.func_74762_e("biomass");
            if (biomass > capacity / 9 * 9) {
                return 9.0f;
            }
            if (biomass > capacity / 9 * 8) {
                return 8.0f;
            }
            if (biomass > capacity / 9 * 7) {
                return 7.0f;
            }
            if (biomass > capacity / 9 * 6) {
                return 6.0f;
            }
            if (biomass > capacity / 9 * 5) {
                return 5.0f;
            }
            if (biomass > capacity / 9 * 4) {
                return 4.0f;
            }
            if (biomass > capacity / 9 * 3) {
                return 3.0f;
            }
            if (biomass > capacity / 9 * 2) {
                return 2.0f;
            }
            if (biomass > capacity / 9 * 1) {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public int getFillLevel(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74762_e("biomass");
        }
        return 0;
    }

    private void setFillLevel(ItemStack stack, int value) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a("biomass", value);
        stack.func_77982_d(nbt);
    }

    public int receiveFillLevel(ItemStack stack, int value) {
        int biomass;
        int space;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        if ((space = capacity - (biomass = nbt.func_74762_e("biomass"))) >= value) {
            this.setFillLevel(stack, biomass + value);
            return value;
        }
        this.setFillLevel(stack, capacity);
        return space;
    }

    public int extractFillLevel(ItemStack stack, int value) {
        int biomass;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        if ((biomass = nbt.func_74762_e("biomass")) >= value) {
            this.setFillLevel(stack, biomass - value);
            return value;
        }
        this.setFillLevel(stack, 0);
        return biomass;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            tooltip.add((ITextComponent)new StringTextComponent(nbt.func_74762_e("biomass") + "/" + capacity));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("0/" + capacity));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == this.field_77701_a) {
            items.add((Object)new ItemStack((IItemProvider)ModItems.BIOMASSCONTAINER));
            ItemStack full = new ItemStack((IItemProvider)ModItems.BIOMASSCONTAINER);
            this.setFillLevel(full, capacity);
            items.add((Object)full);
        }
    }
}

