/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities.capabilities.techvillagertrust;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kaneka.planttech2.entities.capabilities.techvillagertrust.ITechVillagerTrust;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class TechVillagerTrust
implements ITechVillagerTrust,
ICapabilitySerializable<CompoundNBT> {
    @CapabilityInject(value=ITechVillagerTrust.class)
    public static Capability<ITechVillagerTrust> INSTANCE = null;
    private final List<String> keys = ImmutableList.of((Object)"scientist", (Object)"headhunter", (Object)"botanist", (Object)"engineer");
    private Map<String, Integer> trust = new HashMap<String, Integer>();
    private int[] levelcondition = new int[]{10, 50, 100, 200, 400, 800, 1600, 3200, 6400, 12800};
    private final LazyOptional<ITechVillagerTrust> lazyoption = LazyOptional.of(() -> this);

    public TechVillagerTrust() {
        for (String key : this.keys) {
            this.trust.put(key, 0);
        }
    }

    @Override
    public void increaseTrust(String key, int trust, int maxLevel) {
        int maxTrust;
        int actualTrust;
        if (this.trust.containsKey(key) && (actualTrust = this.trust.get(key).intValue()) < (maxTrust = this.levelcondition[maxLevel - 1])) {
            int newValue = Math.min(actualTrust + trust, maxTrust);
            this.trust.put(key, newValue);
        }
    }

    @Override
    public void decreaseTrust(String key, int trust, int minLevel) {
        int minTrust;
        int actualTrust;
        if (this.trust.containsKey(key) && (actualTrust = this.trust.get(key).intValue()) > (minTrust = this.levelcondition[minLevel - 1])) {
            int newValue = Math.max(actualTrust - trust, minTrust);
            this.trust.put(key, newValue);
        }
    }

    @Override
    public void setTrust(String key, int trust) {
        if (this.trust.containsKey(key)) {
            this.trust.put(key, trust);
        }
    }

    @Override
    public int getTrust(String key) {
        if (this.trust.containsKey(key)) {
            int intvalue = this.trust.get(key);
            return intvalue;
        }
        return 0;
    }

    @Override
    public int getMaxLevel() {
        return this.levelcondition.length - 1;
    }

    @Override
    public Map<String, Integer> getTrustsMap() {
        return this.trust;
    }

    @Override
    public int getLevel(String key) {
        if (this.trust.containsKey(key)) {
            int level = 0;
            int trust = this.getTrust(key);
            for (int i = 0; i < this.levelcondition.length && trust >= this.levelcondition[i]; ++i) {
                trust -= this.levelcondition[i];
                ++level;
            }
            return level;
        }
        return 0;
    }

    @Override
    public int getLevelTrust(int level) {
        int trust = 0;
        for (int i = 0; i < level; ++i) {
            trust += this.levelcondition[i];
        }
        return trust;
    }

    @Override
    public List<String> getKeys() {
        return this.keys;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return INSTANCE.orEmpty(cap, this.lazyoption);
    }

    public CompoundNBT serializeNBT() {
        Map<String, Integer> map = this.getTrustsMap();
        CompoundNBT compound = new CompoundNBT();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            compound.func_74768_a(entry.getKey(), entry.getValue().intValue());
        }
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        CompoundNBT nbt2 = nbt;
        for (String key : this.getKeys()) {
            if (!nbt2.func_74764_b(key)) continue;
            this.setTrust(key, nbt2.func_74762_e(key));
        }
    }

    public static boolean isAllowedForEntity(ICapabilityProvider entity) {
        return entity instanceof PlayerEntity && !entity.getCapability(INSTANCE).isPresent();
    }

    public static class TechVillagerTrustStorage
    implements Capability.IStorage<ITechVillagerTrust> {
        public INBT writeNBT(Capability<ITechVillagerTrust> capability, ITechVillagerTrust instance, Direction side) {
            if (instance instanceof TechVillagerTrust) {
                return ((TechVillagerTrust)instance).serializeNBT();
            }
            return new CompoundNBT();
        }

        public void readNBT(Capability<ITechVillagerTrust> capability, ITechVillagerTrust instance, Direction side, INBT nbt) {
            if (instance instanceof TechVillagerTrust) {
                ((TechVillagerTrust)instance).deserializeNBT((CompoundNBT)nbt);
            }
        }
    }
}

