/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.items.AdvancedAnalyserItem;
import net.kaneka.planttech2.items.AnalyserItem;
import net.kaneka.planttech2.items.CropRemover;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.tileentity.CropsTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class CropBaseBlock
extends ContainerBlock {
    public static final IntegerProperty GROWSTATE = IntegerProperty.func_177719_a((String)"growstate", (int)0, (int)7);
    private String entryName;

    public CropBaseBlock(String entryName) {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200943_b(0.5f));
        this.entryName = entryName;
        this.setRegistryName(entryName + "_crop");
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CropsTileEntity();
    }

    public void updateCrop(World world, BlockPos pos, HashMapCropTraits traits) {
        block3: {
            block2: {
                BlockState state = world.func_180495_p(pos);
                int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
                if (growstate >= 7) break block2;
                if (!this.canGrow(world, pos, traits)) break block3;
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)GROWSTATE, (Comparable)Integer.valueOf(Integer.valueOf(growstate) + 1)));
                break block3;
            }
            List<BlockPos> neighborpos = this.getNeighborBlockPosRandom(pos);
            for (BlockPos blockpos : neighborpos) {
                if (world.func_180495_p(blockpos).func_177230_c() != ModBlocks.CROPBARS) continue;
                List<BlockPos> cropbarneighbors = this.getNeighborBlockPosRandomExeptOne(blockpos, pos);
                for (BlockPos possiblePartner : cropbarneighbors) {
                    if (!(world.func_180495_p(possiblePartner).func_177230_c() instanceof CropBaseBlock) || !(world.func_175625_s(possiblePartner) instanceof CropsTileEntity)) continue;
                    HashMapCropTraits partnertraits = ((CropsTileEntity)world.func_175625_s(possiblePartner)).getTraits();
                    world.func_175656_a(blockpos, this.func_176223_P());
                    if (!(world.func_175625_s(blockpos) instanceof CropsTileEntity) || !(world.func_175625_s(pos) instanceof CropsTileEntity)) continue;
                    ((CropsTileEntity)world.func_175625_s(blockpos)).setTraits(((CropsTileEntity)world.func_175625_s(pos)).getTraits().calculateNewTraits(partnertraits));
                    break;
                }
                if (world.func_180495_p(blockpos).func_177230_c() instanceof CropBaseBlock) break;
                world.func_175656_a(blockpos, this.func_176223_P());
                if (!(world.func_175625_s(blockpos) instanceof CropsTileEntity) || !(world.func_175625_s(pos) instanceof CropsTileEntity)) break;
                ((CropsTileEntity)world.func_175625_s(blockpos)).setTraits(((CropsTileEntity)world.func_175625_s(pos)).getTraits().copy());
                break;
            }
        }
    }

    public void updateCreative(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
        if (growstate < 7) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)GROWSTATE, (Comparable)Integer.valueOf(7)));
        }
    }

    private List<BlockPos> getNeighborBlockPosRandom(BlockPos pos) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.func_177978_c());
        neighbors.add(pos.func_177974_f());
        neighbors.add(pos.func_177968_d());
        neighbors.add(pos.func_177976_e());
        Collections.shuffle(neighbors);
        return neighbors;
    }

    private List<BlockPos> getNeighborBlockPosRandomExeptOne(BlockPos pos, BlockPos exept) {
        List<BlockPos> neighbors = this.getNeighborBlockPosRandom(pos);
        neighbors.remove(exept);
        return neighbors;
    }

    private boolean canGrow(World world, BlockPos pos, HashMapCropTraits traits) {
        if (!this.enoughtLight(world, pos, traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY))) {
            return false;
        }
        if (!this.enoughtWater(world, pos, traits.getTrait(EnumTraitsInt.WATERSENSITIVITY))) {
            return false;
        }
        if (!this.rightSoil(world, pos, traits.getType())) {
            return false;
        }
        return this.rightTemperature(world, pos, traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE));
    }

    public String[] canGrowString(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        String[] messages = new String[10];
        if (te instanceof CropsTileEntity) {
            HashMapCropTraits traits = ((CropsTileEntity)te).getTraits();
            if (!this.enoughtLight(world, pos, traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY))) {
                messages[1] = "Not enough light";
            }
            if (!this.enoughtWater(world, pos, traits.getTrait(EnumTraitsInt.WATERSENSITIVITY))) {
                messages[2] = "Not enough water";
            }
            if (!this.rightSoil(world, pos, traits.getType())) {
                messages[3] = "Not right soil";
            }
            if (!this.rightTemperature(world, pos, traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE))) {
                messages[4] = "Not right temperature";
            }
        } else {
            messages[0] = "error";
        }
        return messages;
    }

    public boolean enoughtLight(World world, BlockPos pos, int lightsensitivity) {
        if (!world.isAreaLoaded(pos, 1)) {
            return false;
        }
        return world.func_201669_a(pos, 0) >= 14 - lightsensitivity;
    }

    public boolean enoughtWater(World world, BlockPos pos, int waterSensitivity) {
        for (BlockPos blockpos$mutableblockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1 * (waterSensitivity + 1), 0, -1 * (waterSensitivity + 1)), (BlockPos)pos.func_177982_a(waterSensitivity + 1, -1, waterSensitivity + 1))) {
            if (world.func_180495_p(blockpos$mutableblockpos).func_185904_a() == Material.field_151586_h) {
                return true;
            }
            if (!world.func_180495_p(blockpos$mutableblockpos).func_196959_b((IProperty)BlockStateProperties.field_208198_y) || !((Boolean)world.func_180495_p(blockpos$mutableblockpos).func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean rightSoil(World world, BlockPos pos, String name) {
        ItemStack stack = PlantTechMain.croplist.getEntryByName(name).getSoil();
        if (stack.func_190926_b()) {
            return true;
        }
        if (stack.func_77973_b() instanceof BlockItem) {
            Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
            BlockState state = world.func_180495_p(pos.func_177977_b());
            return state.func_177230_c() == block;
        }
        return false;
    }

    public boolean rightTemperature(World world, BlockPos pos, String name, int tolerance) {
        EnumTemperature temp = PlantTechMain.croplist.getEntryByName(name).getTemperature();
        return temp.inRange(world.func_180494_b(pos).func_185353_n(), tolerance);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{GROWSTATE});
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        if (willHarvest && !player.func_184812_l_()) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 1);
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
        if (growstate > 6 && hand.equals((Object)Hand.MAIN_HAND) && !worldIn.field_72995_K) {
            ItemStack holdItem = player.func_184586_b(Hand.MAIN_HAND);
            if (!holdItem.func_190926_b() && (holdItem.func_77973_b() instanceof AnalyserItem || holdItem.func_77973_b() instanceof AdvancedAnalyserItem || holdItem.func_77973_b() instanceof CropRemover)) {
                return super.func_220051_a(state, worldIn, pos, player, hand, ray);
            }
            NonNullList drops = NonNullList.func_191196_a();
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof CropsTileEntity) {
                ((CropsTileEntity)te).dropsRemoveOneSeed((NonNullList<ItemStack>)drops, growstate);
                for (ItemStack stack : drops) {
                    CropBaseBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
                }
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)GROWSTATE, (Comparable)Integer.valueOf(0)));
            }
        }
        return super.func_220051_a(state, worldIn, pos, player, hand, ray);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList drops = Lists.newArrayList();
        int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
        BlockPos pos = (BlockPos)builder.func_216019_b(LootParameters.field_216286_f);
        TileEntity te = builder.func_216018_a().func_175625_s(pos);
        if (te instanceof CropsTileEntity) {
            ((CropsTileEntity)te).addDrops(drops, growstate);
            drops.add(new ItemStack((IItemProvider)ModBlocks.CROPBARS));
        }
        return drops;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public BlockRenderType func_149645_b(BlockState iBlockState) {
        return BlockRenderType.MODEL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public static boolean isOpaque(VoxelShape shape) {
        return true;
    }

    public static class ColorHandler
    implements IBlockColor {
        public int getColor(BlockState state, IEnviromentBlockReader world, BlockPos pos, int tintindex) {
            if (tintindex == 0) {
                return PlantTechMain.croplist.getEntryByName(((CropBaseBlock)state.func_177230_c()).getEntryName()).getSeedColor();
            }
            return -1;
        }
    }
}

