/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterBlock;
import net.silentchaos512.mechanisms.block.batterybox.BatteryBoxBlock;
import net.silentchaos512.mechanisms.block.compressor.CompressorBlock;
import net.silentchaos512.mechanisms.block.crusher.CrusherBlock;
import net.silentchaos512.mechanisms.block.dryingrack.DryingRackBlock;
import net.silentchaos512.mechanisms.block.electricfurnace.ElectricFurnaceBlock;
import net.silentchaos512.mechanisms.block.generator.coal.CoalGeneratorBlock;
import net.silentchaos512.mechanisms.block.generator.lava.LavaGeneratorBlock;
import net.silentchaos512.mechanisms.block.wire.WireBlock;
import net.silentchaos512.mechanisms.init.Metals;
import net.silentchaos512.mechanisms.init.ModItems;
import net.silentchaos512.mechanisms.init.Ores;
import net.silentchaos512.mechanisms.util.MachineTier;

public final class ModBlocks {
    public static final List<DryingRackBlock> DRYING_RACKS = new ArrayList<DryingRackBlock>();
    public static AlloySmelterBlock basicAlloySmelter;
    public static AlloySmelterBlock alloySmelter;
    public static CrusherBlock basicCrusher;
    public static CrusherBlock crusher;
    public static CompressorBlock compressor;
    public static ElectricFurnaceBlock electricFurnace;
    public static CoalGeneratorBlock coalGenerator;
    public static LavaGeneratorBlock lavaGenerator;
    public static BatteryBoxBlock batteryBox;
    public static WireBlock wire;

    private ModBlocks() {
    }

    public static void registerAll(RegistryEvent.Register<Block> event) {
        Arrays.stream(Ores.values()).forEach(ore -> ModBlocks.register(ore.getName() + "_ore", ore.getBlock()));
        Arrays.stream(Metals.values()).forEach(metal -> ModBlocks.register(metal.getName() + "_block", metal.asBlock()));
        DRYING_RACKS.add(ModBlocks.register("oak_drying_rack", new DryingRackBlock()));
        DRYING_RACKS.add(ModBlocks.register("birch_drying_rack", new DryingRackBlock()));
        DRYING_RACKS.add(ModBlocks.register("spruce_drying_rack", new DryingRackBlock()));
        DRYING_RACKS.add(ModBlocks.register("jungle_drying_rack", new DryingRackBlock()));
        DRYING_RACKS.add(ModBlocks.register("dark_oak_drying_rack", new DryingRackBlock()));
        DRYING_RACKS.add(ModBlocks.register("acacia_drying_rack", new DryingRackBlock()));
        ModBlocks.register("stone_machine_frame", new GlassBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185851_d)));
        ModBlocks.register("alloy_machine_frame", new GlassBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185852_e)));
        basicAlloySmelter = ModBlocks.register("basic_alloy_smelter", new AlloySmelterBlock(MachineTier.BASIC));
        alloySmelter = ModBlocks.register("alloy_smelter", new AlloySmelterBlock(MachineTier.STANDARD));
        basicCrusher = ModBlocks.register("basic_crusher", new CrusherBlock(MachineTier.BASIC));
        crusher = ModBlocks.register("crusher", new CrusherBlock(MachineTier.STANDARD));
        compressor = ModBlocks.register("compressor", new CompressorBlock());
        electricFurnace = ModBlocks.register("electric_furnace", new ElectricFurnaceBlock());
        coalGenerator = ModBlocks.register("coal_generator", new CoalGeneratorBlock());
        lavaGenerator = ModBlocks.register("lava_generator", new LavaGeneratorBlock());
        batteryBox = ModBlocks.register("battery_box", new BatteryBoxBlock());
        wire = ModBlocks.register("wire", new WireBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(1.0f, 5.0f)));
    }

    private static <T extends Block> T register(String name, T block) {
        BlockItem item = new BlockItem(block, new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP));
        return ModBlocks.register(name, block, item);
    }

    private static <T extends Block> T register(String name, T block, @Nullable BlockItem item) {
        ResourceLocation id = SilentMechanisms.getId(name);
        block.setRegistryName(id);
        ForgeRegistries.BLOCKS.register(block);
        if (item != null) {
            ModItems.BLOCKS_TO_REGISTER.put(name, item);
        }
        return block;
    }
}

