/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.capability;

import java.util.Arrays;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.mechanisms.capability.EnergyStorageImplBase;

public class EnergyStorageImpl
extends EnergyStorageImplBase {
    private final EnumMap<Direction, LazyOptional<Connection>> connections = new EnumMap(Direction.class);
    private final TileEntity tileEntity;

    public EnergyStorageImpl(int capacity, int maxReceive, int maxExtract, TileEntity tileEntity) {
        super(capacity, maxReceive, maxExtract);
        this.tileEntity = tileEntity;
        Arrays.stream(Direction.values()).forEach(d -> this.connections.put((Direction)d, (LazyOptional<Connection>)LazyOptional.of(() -> new Connection())));
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (side == null) {
            return super.getCapability(cap, null);
        }
        return CapabilityEnergy.ENERGY.orEmpty(cap, this.connections.get(side).cast());
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.connections.values().forEach(LazyOptional::invalidate);
    }

    public void createEnergy(int amount) {
        this.energy = Math.min(this.energy + amount, this.getMaxEnergyStored());
    }

    public void consumeEnergy(int amount) {
        this.energy = Math.max(this.energy - amount, 0);
    }

    public void setEnergyDirectly(int amount) {
        this.energy = amount;
    }

    public class Connection
    implements IEnergyStorage {
        private long lastReceiveTick;

        public int receiveEnergy(int maxReceive, boolean simulate) {
            World world = EnergyStorageImpl.this.tileEntity.func_145831_w();
            if (world == null) {
                return 0;
            }
            int received = EnergyStorageImpl.this.receiveEnergy(maxReceive, simulate);
            if (received > 0 && !simulate) {
                this.lastReceiveTick = world.func_82737_E();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            World world = EnergyStorageImpl.this.tileEntity.func_145831_w();
            if (world == null) {
                return 0;
            }
            long time = world.func_82737_E();
            if (time != this.lastReceiveTick) {
                return EnergyStorageImpl.this.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            return EnergyStorageImpl.this.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return EnergyStorageImpl.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return EnergyStorageImpl.this.canExtract();
        }

        public boolean canReceive() {
            return EnergyStorageImpl.this.canReceive();
        }
    }
}

