/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.wire;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.mechanisms.api.ConnectionType;
import net.silentchaos512.mechanisms.block.wire.WireBlock;
import net.silentchaos512.mechanisms.block.wire.WireTileEntity;
import net.silentchaos512.mechanisms.util.EnergyUtils;

public class WireNetwork
implements IEnergyStorage {
    private final IBlockReader world;
    private final Map<BlockPos, Set<Connection>> connections = new HashMap<BlockPos, Set<Connection>>();

    public WireNetwork(IBlockReader world) {
        this.world = world;
    }

    public boolean contains(IBlockReader world, BlockPos pos) {
        return this.world == world && this.connections.containsKey(pos);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energySent = 0;
        for (Map.Entry<BlockPos, Set<Connection>> entry : this.connections.entrySet()) {
            BlockPos pos = entry.getKey();
            Set<Connection> connections = entry.getValue();
            for (Connection con : connections) {
                IEnergyStorage energy;
                if (!con.type.canReceive() || (energy = EnergyUtils.getEnergy(this.world, pos.func_177972_a(con.side))) == null) continue;
                energySent += energy.receiveEnergy(maxReceive - energySent, simulate);
            }
        }
        return energySent;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energySent = 0;
        for (Map.Entry<BlockPos, Set<Connection>> entry : this.connections.entrySet()) {
            BlockPos pos = entry.getKey();
            Set<Connection> connections = entry.getValue();
            for (Connection con : connections) {
                IEnergyStorage energy;
                if (!con.type.canExtract() || (energy = EnergyUtils.getEnergy(this.world, pos.func_177972_a(con.side))) == null) continue;
                energySent += energy.extractEnergy(maxExtract - energySent, simulate);
            }
        }
        return energySent;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public static WireNetwork buildNetwork(IBlockReader world, BlockPos pos) {
        WireNetwork network = new WireNetwork(world);
        WireNetwork.buildWireSet(world, pos, new HashSet<BlockPos>()).forEach(p -> {
            HashSet<Connection> connections = new HashSet<Connection>();
            for (Direction direction : Direction.values()) {
                TileEntity te = world.func_175625_s(p.func_177972_a(direction));
                if (te == null || te instanceof WireTileEntity || !te.getCapability(CapabilityEnergy.ENERGY).isPresent()) continue;
                ConnectionType type = WireBlock.getConnection(world.func_180495_p(p), direction);
                connections.add(new Connection(direction, type));
            }
            network.connections.put((BlockPos)p, (Set<Connection>)connections);
        });
        return network;
    }

    private static Set<BlockPos> buildWireSet(IBlockReader world, BlockPos pos, Set<BlockPos> set) {
        for (Direction side : Direction.values()) {
            BlockPos pos1 = pos.func_177972_a(side);
            if (set.contains(pos1) || !(world.func_175625_s(pos1) instanceof WireTileEntity)) continue;
            set.add(pos1);
            set.addAll(WireNetwork.buildWireSet(world, pos1, set));
        }
        return set;
    }

    public static class Connection {
        private final Direction side;
        private final ConnectionType type;

        public Connection(Direction side, ConnectionType type) {
            this.side = side;
            this.type = type;
        }
    }
}

