/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.generator.lava;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseScreen;
import net.silentchaos512.mechanisms.block.generator.lava.LavaGeneratorContainer;
import net.silentchaos512.mechanisms.util.TextUtil;

public class LavaGeneratorScreen
extends AbstractMachineBaseScreen<LavaGeneratorContainer> {
    public static final ResourceLocation TEXTURE = SilentMechanisms.getId("textures/gui/lava_generator.png");

    public LavaGeneratorScreen(LavaGeneratorContainer container, PlayerInventory playerInventory, ITextComponent titleIn) {
        super(container, playerInventory, titleIn);
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return TEXTURE;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    @Override
    protected void func_191948_b(int mouseX, int mouseY) {
        ITextComponent text;
        if (this.func_195359_a(135, 17, 13, 51, mouseX, mouseY)) {
            text = TextUtil.fluidWithMax(((LavaGeneratorContainer)this.field_147002_h).getTank());
            this.renderTooltip(text.func_150254_d(), mouseX, mouseY);
        }
        if (this.func_195359_a(153, 17, 13, 51, mouseX, mouseY)) {
            text = TextUtil.energyWithMax(((LavaGeneratorContainer)this.field_147002_h).getEnergyStored(), ((LavaGeneratorContainer)this.field_147002_h).tileEntity.getMaxEnergyStored());
            this.renderTooltip(text.func_150254_d(), mouseX, mouseY);
        }
        super.func_191948_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.minecraft == null) {
            return;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int xPos = (this.width - this.field_146999_f) / 2;
        int yPos = (this.height - this.field_147000_g) / 2;
        this.blit(xPos, yPos, 0, 0, this.field_146999_f, this.field_147000_g);
        int energyBarHeight = 50 * ((LavaGeneratorContainer)this.field_147002_h).getEnergyStored() / ((LavaGeneratorContainer)this.field_147002_h).tileEntity.getMaxEnergyStored();
        if (energyBarHeight > 0) {
            this.blit(xPos + 154, yPos + 68 - energyBarHeight, 176, 31, 12, energyBarHeight);
        }
        IFluidHandler tank = ((LavaGeneratorContainer)this.field_147002_h).getTank();
        LavaGeneratorScreen.renderGuiTank(tank, xPos + 136, yPos + 18, 0.0, 12.0, 50.0);
    }

    public static void renderGuiTank(IFluidHandler tank, double x, double y, double zLevel, double width, double height) {
        FluidStack fluid = tank.getFluidInTank(0);
        int amount = fluid.getAmount();
        int capacity = tank.getTankCapacity(0);
        if (fluid.getFluid() == null || amount <= 0) {
            return;
        }
        ResourceLocation stillTexture = fluid.getFluid().getAttributes().getStillTexture();
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_195424_a(stillTexture);
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV).func_181675_d();
                tes.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GlStateManager.disableBlend();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

