/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.generator.coal;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.ForgeEventFactory;
import net.silentchaos512.mechanisms.block.generator.AbstractGeneratorTileEntity;
import net.silentchaos512.mechanisms.block.generator.coal.CoalGeneratorContainer;
import net.silentchaos512.mechanisms.init.ModTags;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.util.TextUtil;

public class CoalGeneratorTileEntity
extends AbstractGeneratorTileEntity {
    public static final int MAX_ENERGY = 10000;
    public static final int MAX_SEND = 500;
    public static final int ENERGY_CREATED_PER_TICK = 60;

    public CoalGeneratorTileEntity() {
        super(ModTileEntities.coalGenerator, 1, 10000, 0, 500);
    }

    static boolean isFuel(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(ModTags.Items.COAL_GENERATOR_FUELS) && AbstractFurnaceTileEntity.func_213991_b((ItemStack)stack);
    }

    private static int getBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int ret = stack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret == -1 ? AbstractFurnaceTileEntity.func_214001_f().getOrDefault(stack.func_77973_b(), 0) : ret));
    }

    @Override
    protected boolean hasFuel() {
        return CoalGeneratorTileEntity.isFuel(this.func_70301_a(0));
    }

    @Override
    protected void consumeFuel() {
        ItemStack fuel = this.func_70301_a(0);
        this.burnTime = CoalGeneratorTileEntity.getBurnTime(fuel);
        if (this.burnTime > 0) {
            this.totalBurnTime = this.burnTime;
            if (fuel.hasContainerItem()) {
                this.func_70299_a(0, fuel.getContainerItem());
            } else if (!fuel.func_190926_b()) {
                fuel.func_190918_g(1);
                if (fuel.func_190926_b()) {
                    this.func_70299_a(0, fuel.getContainerItem());
                }
            }
        }
    }

    @Override
    protected int getEnergyCreatedPerTick() {
        return 60;
    }

    @Override
    protected BlockState getActiveState() {
        return (BlockState)this.func_195044_w().func_206870_a((IProperty)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(true));
    }

    @Override
    protected BlockState getInactiveState() {
        return (BlockState)this.func_195044_w().func_206870_a((IProperty)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(false));
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return CoalGeneratorTileEntity.isFuel(stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return !CoalGeneratorTileEntity.isFuel(stack);
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "coal_generator", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new CoalGeneratorContainer(id, playerInventory, this, this.fields);
    }
}

