/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.dryingrack;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.silentchaos512.lib.util.PlayerUtils;
import net.silentchaos512.mechanisms.crafting.recipe.DryingRecipe;
import net.silentchaos512.mechanisms.init.ModTileEntities;

public class DryingRackTileEntity
extends TileEntity
implements IInventory,
ITickableTileEntity {
    private final NonNullList<ItemStack> items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private int processTime;

    public DryingRackTileEntity() {
        super(ModTileEntities.dryingRack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.items.get(0);
    }

    public boolean interact(PlayerEntity player) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b()) {
            PlayerUtils.giveItem((PlayerEntity)player, (ItemStack)stack);
            this.func_70298_a(0, 1);
            return true;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b()) {
            this.func_70299_a(0, heldItem.func_77979_a(1));
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.func_191420_l()) {
            return;
        }
        DryingRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(DryingRecipe.RECIPE_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
        if (recipe != null) {
            ++this.processTime;
            if (this.processTime >= recipe.getProcessTime()) {
                this.func_70299_a(0, recipe.func_77572_b(this));
                this.processTime = 0;
                this.sendUpdate();
            }
        } else {
            this.processTime = 0;
        }
    }

    private void sendUpdate() {
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.func_70301_a(0).func_190926_b();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(0);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.items.set(0, (Object)stack);
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Item")) {
            this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Item")));
        }
        this.processTime = compound.func_74762_e("ProcessTime");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStack stack = this.getItem();
        if (!stack.func_190926_b()) {
            compound.func_218657_a("Item", (INBT)stack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74768_a("ProcessTime", this.processTime);
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        ItemStack stack = this.getItem();
        if (!stack.func_190926_b()) {
            nbt.func_218657_a("Item", (INBT)stack.func_77955_b(new CompoundNBT()));
        }
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (pkt.func_148857_g().func_74764_b("Item")) {
            this.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)pkt.func_148857_g().func_74775_l("Item")));
        }
    }
}

