/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.network.ConnectionType;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.FMLMCRegisterPacketHandler;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.ICustomPacket;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkHooks {
    private static final Logger LOGGER = LogManager.getLogger();

    public static String getFMLVersion(String ip) {
        return ip.contains("\u0000") ? (Objects.equals(ip.split("\u0000")[1], "FML2") ? "FML2" : ip.split("\u0000")[1]) : "NONE";
    }

    public static ConnectionType getConnectionType(Supplier<NetworkManager> connection) {
        return ConnectionType.forVersionFlag((String)connection.get().channel().attr(FMLNetworkConstants.FML_NETVERSION).get());
    }

    public static IPacket<?> getEntitySpawningPacket(Entity entity) {
        return FMLNetworkConstants.playChannel.toVanillaPacket(new FMLPlayMessages.SpawnEntity(entity), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static boolean onCustomPayload(ICustomPacket<?> packet, NetworkManager manager) {
        return NetworkRegistry.findTarget(packet.getName()).map(ni -> ni.dispatch(packet.getDirection(), packet, manager)).orElse(Boolean.FALSE);
    }

    public static void registerServerLoginChannel(NetworkManager manager, CHandshakePacket packet) {
        manager.channel().attr(FMLNetworkConstants.FML_NETVERSION).set((Object)packet.getFMLVersion());
        FMLHandshakeHandler.registerHandshake(manager, NetworkDirection.LOGIN_TO_CLIENT);
    }

    public static synchronized void registerClientLoginChannel(NetworkManager manager) {
        manager.channel().attr(FMLNetworkConstants.FML_NETVERSION).set((Object)"NONE");
        FMLHandshakeHandler.registerHandshake(manager, NetworkDirection.LOGIN_TO_SERVER);
    }

    public static synchronized void sendMCRegistryPackets(NetworkManager manager, String direction) {
        Set<ResourceLocation> resourceLocations = NetworkRegistry.buildChannelVersions().keySet().stream().filter(rl -> !Objects.equals(rl.func_110624_b(), "minecraft")).collect(Collectors.toSet());
        FMLMCRegisterPacketHandler.INSTANCE.addChannels(resourceLocations, manager);
        FMLMCRegisterPacketHandler.INSTANCE.sendRegistry(manager, NetworkDirection.valueOf(direction));
    }

    public static void handleClientLoginSuccess(NetworkManager manager) {
        if (manager == null || manager.channel() == null) {
            throw new NullPointerException("ARGH! Network Manager is null (" + manager != null ? "CHANNEL" : "MANAGER)");
        }
        if (NetworkHooks.getConnectionType(() -> manager) == ConnectionType.VANILLA) {
            LOGGER.info("Connected to a vanilla server. Catching up missing behaviour.");
            ConfigTracker.INSTANCE.loadDefaultServerConfigs();
        } else {
            LOGGER.info("Connected to a modded server.");
        }
    }

    public static boolean tickNegotiation(ServerLoginNetHandler netHandlerLoginServer, NetworkManager networkManager, ServerPlayerEntity player) {
        return FMLHandshakeHandler.tickLogin(networkManager);
    }

    public static void openGui(ServerPlayerEntity player, INamedContainerProvider containerSupplier) {
        NetworkHooks.openGui(player, containerSupplier, (PacketBuffer buf) -> {});
    }

    public static void openGui(ServerPlayerEntity player, INamedContainerProvider containerSupplier, BlockPos pos) {
        NetworkHooks.openGui(player, containerSupplier, (PacketBuffer buf) -> buf.func_179255_a(pos));
    }

    public static void openGui(ServerPlayerEntity player, INamedContainerProvider containerSupplier, Consumer<PacketBuffer> extraDataWriter) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        player.func_71128_l();
        player.func_71117_bO();
        int openContainerId = player.field_71139_cq;
        PacketBuffer extraData = new PacketBuffer(Unpooled.buffer());
        extraDataWriter.accept(extraData);
        extraData.readerIndex(0);
        PacketBuffer output = new PacketBuffer(Unpooled.buffer());
        output.func_150787_b(extraData.readableBytes());
        output.writeBytes((ByteBuf)extraData);
        if (output.readableBytes() > 32600 || output.readableBytes() < 1) {
            throw new IllegalArgumentException("Invalid PacketBuffer for openGui, found " + output.readableBytes() + " bytes");
        }
        Container c = containerSupplier.createMenu(openContainerId, player.field_71071_by, (PlayerEntity)player);
        ContainerType type = c.func_216957_a();
        FMLPlayMessages.OpenContainer msg = new FMLPlayMessages.OpenContainer(type, openContainerId, containerSupplier.func_145748_c_(), output);
        FMLNetworkConstants.playChannel.sendTo(msg, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        player.field_71070_bA = c;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)player, c));
    }
}

