/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityGrave
extends TileEntityWritableGrave {
    private static final List<BlockPos> POS_FOR_REMOVAL = new ArrayList<BlockPos>();
    protected final ItemStackHandler inventory = new ItemStackHandler(120);
    @Nullable
    private UUID ownerId = null;
    private boolean needAccess = false;

    public TileEntityGrave() {
        super(ModBlocks.tile_grave);
    }

    @Override
    public boolean canShowFog() {
        return true;
    }

    public void func_145843_s() {
        this.field_145846_f = TileEntityGrave.removeTile(this.field_174879_c);
        if (this.field_145846_f) {
            this.invalidateCaps();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void giveInventory(@Nullable PlayerEntity player) {
        int i;
        if (this.field_145850_b.field_72995_K || player == null || player instanceof FakePlayer) {
            return;
        }
        EventFactory.onRestoreInventory(player, this);
        for (i = this.inventory.getSlots() - 1; i >= 0; --i) {
            if (!InventoryHelper.autoequip(this.inventory.getStackInSlot(i), player)) continue;
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack.func_77946_l());
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        DeathHandler.INSTANCE.removeGrave(new Location(this.field_174879_c, (IWorld)this.field_145850_b));
        EntityHelper.capPotionDuration((LivingEntity)player, ModEffects.ghostly_shape, 100);
        player.field_71069_bz.func_75142_b();
        Helper.removeNoEvent(this.field_145850_b, this.field_174879_c);
        this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, 1.0f);
        player.func_145747_a(LangKey.MESSAGE_OPEN_GRAVE_SUCCESS.getTranslation());
        TileEntityGrave.setTileForRemoval(this.field_174879_c);
        this.field_145850_b.func_175713_t(this.field_174879_c);
    }

    public void setOwner(Entity owner, long deathDate, boolean needAccess) {
        super.setOwner(owner, deathDate);
        this.ownerId = owner.func_110124_au();
        this.needAccess = needAccess;
    }

    public boolean isOwner(PlayerEntity owner) {
        return this.ownerId == null ? this.hasOwner() && this.ownerName.equals(owner.func_146103_bH().getName()) : this.ownerId.equals(owner.func_110124_au());
    }

    public boolean getNeedAccess() {
        return this.needAccess && ((Integer)ConfigTombstone.general.decayTime.get() == -1 || !TimeHelper.isSystemTimeElapsed(this.deathDate, TimeUnit.MINUTES.toMillis(((Integer)ConfigTombstone.general.decayTime.get()).intValue())));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        if (this.ownerId != null) {
            compound.func_186854_a("owner_id", this.ownerId);
        }
        compound.func_74757_a("need_access", this.needAccess);
        return compound;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        if (compound.func_186855_b("owner_id")) {
            this.ownerId = compound.func_186857_a("owner_id");
        }
        this.needAccess = compound.func_74767_n("need_access");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtension = 1.0;
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - renderExtension, (double)this.field_174879_c.func_177956_o() - renderExtension, (double)this.field_174879_c.func_177952_p() - renderExtension, (double)(this.field_174879_c.func_177958_n() + 1) + renderExtension, (double)(this.field_174879_c.func_177956_o() + 1) + renderExtension, (double)(this.field_174879_c.func_177952_p() + 1) + renderExtension);
    }

    public static boolean removeTile(BlockPos pos) {
        return POS_FOR_REMOVAL.remove(pos);
    }

    public static void setTileForRemoval(BlockPos pos) {
        POS_FOR_REMOVAL.add(pos);
    }
}

