/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModEffects;

public class ItemVoodooPoppet
extends ItemGeneric
implements ISoulConsumer {
    public ItemVoodooPoppet() {
        super("voodoo_poppet", ItemVoodooPoppet.getBuilder(true));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        return (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getTranslation(name) : name).func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            boolean hasProt = false;
            for (PoppetProtections prot : PoppetProtections.values()) {
                if (!this.hasProtection(stack, prot)) continue;
                list.add(LangKey.makeTranslationWithStyle(StyleType.TOOLTIP_ITEM, this.func_77658_a() + "." + prot.getName(), new Object[0]));
                hasProt = true;
            }
            this.addItemUse(list, this.isEnchanted(stack) ? "3" : (hasProt ? "2" : "1"), new Object[0]);
            if (EntityHelper.getPerkLevelWithBonus((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ModPerks.voodoo_poppet) <= 0) {
                this.addWarn(list, LangKey.MESSAGE_PERK_REQUIRED, LangKey.makeTranslationWithStyle(StyleType.TOOLTIP_ITEM, ModPerks.voodoo_poppet.getTranslationKey(), new Object[0]));
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        return ConfigTombstone.allowed_magic_items.isAllowedVoodooPoppet();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_SUCCESS.getTranslation();
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        return LangKey.MESSAGE_NO_PROTECTION_TO_SEAL.getTranslation();
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        if (!this.isEnchanted(stack) && Arrays.stream(PoppetProtections.values()).anyMatch(p -> this.hasProtection(stack, (PoppetProtections)((Object)p)))) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return true;
        }
        return false;
    }

    public ItemStack addProtection(ItemStack stack, PoppetProtections prot) {
        if (stack.func_77973_b() == this && !this.isEnchanted(stack) && !this.hasProtection(stack, prot)) {
            NBTStackHelper.setBoolean(stack, "poppet_prot_" + prot.ordinal(), true);
        }
        return stack;
    }

    public boolean hasProtection(ItemStack stack, PoppetProtections prot) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "poppet_prot_" + prot.ordinal());
    }

    public boolean removeProtection(ItemStack stack, PoppetProtections prot) {
        return NBTStackHelper.removeKeyName(stack, "poppet_prot_" + prot.ordinal());
    }

    public boolean preventDeath(PlayerEntity player, ItemStack stack, PoppetProtections prot) {
        if (this.canPreventDeath(stack, prot) && this.removeProtection(stack, prot)) {
            NBTStackHelper.setBoolean(stack, "enchant", false);
            switch (prot) {
                case DROWN: {
                    EntityHelper.addEffect((LivingEntity)player, Effects.field_76428_l, 1200, 10, new boolean[0]);
                    EntityHelper.addEffect((LivingEntity)player, Effects.field_76427_o, 1200, 1, new boolean[0]);
                    break;
                }
                case BURN: {
                    player.func_70066_B();
                    EntityHelper.addEffect((LivingEntity)player, Effects.field_76428_l, 1200, 10, new boolean[0]);
                    EntityHelper.addEffect((LivingEntity)player, Effects.field_76426_n, 1200, 1, new boolean[0]);
                    break;
                }
                case STARVE: {
                    EntityHelper.addEffect((LivingEntity)player, Effects.field_76428_l, 1200, 10, new boolean[0]);
                    EntityHelper.addEffect((LivingEntity)player, Effects.field_76443_y, 1200, 1, new boolean[0]);
                    break;
                }
                case FALL: {
                    EntityHelper.addEffect((LivingEntity)player, Effects.field_76428_l, 1200, 10, new boolean[0]);
                    EntityHelper.addEffect((LivingEntity)player, ModEffects.feather_fall, 1200, 1, new boolean[0]);
                    break;
                }
                case WITHER: {
                    EntityHelper.addEffect((LivingEntity)player, Effects.field_76428_l, 1200, 10, new boolean[0]);
                    EntityHelper.addEffect((LivingEntity)player, ModEffects.purification, 1200, 1, new boolean[0]);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean canPreventDeath(ItemStack stack, PoppetProtections prot) {
        return this.isEnchanted(stack) && NBTStackHelper.getBoolean(stack, "poppet_prot_" + prot.ordinal());
    }

    @Nullable
    public PoppetProtections getPoppetProtections(DamageSource srcDmg) {
        return Arrays.stream(PoppetProtections.values()).filter(p -> ((PoppetProtections)p).srcDmg.contains(srcDmg)).findFirst().orElse(null);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TBSoulConsumerProvider(this);
    }

    public static enum PoppetProtections {
        DROWN(LangKey.MESSAGE_PREVENT_DEATH_DROWN, DamageSource.field_76369_e),
        BURN(LangKey.MESSAGE_PREVENT_DEATH_BURN, DamageSource.field_76371_c, DamageSource.field_76372_a, DamageSource.field_76370_b),
        STARVE(LangKey.MESSAGE_PREVENT_DEATH_STARVE, DamageSource.field_76366_f),
        FALL(LangKey.MESSAGE_PREVENT_DEATH_FALL, DamageSource.field_76379_h),
        WITHER(LangKey.MESSAGE_PREVENT_DEATH_WITHER, DamageSource.field_82727_n);

        private final LangKey key;
        private final List<DamageSource> srcDmg;

        private PoppetProtections(LangKey key, DamageSource ... srcDmg) {
            this.key = key;
            this.srcDmg = Arrays.asList(srcDmg);
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public LangKey getLangKey() {
            return this.key;
        }

        public static PoppetProtections getRandomProtection() {
            return PoppetProtections.values()[Helper.getRandom(0, PoppetProtections.values().length - 1)];
        }
    }
}

