/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemLostTablet
extends ItemGraveMagic {
    public ItemLostTablet() {
        super("lost_tablet");
        this.func_185043_a(new ResourceLocation("structure"), (stack, world, player) -> {
            SupportStructures structureType = this.getStructureType(stack);
            if (structureType == null) {
                return 0.0f;
            }
            if (structureType == SupportStructures.VILLAGE) {
                return 0.5f;
            }
            return 1.0f;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            Location location = this.getStructurePos(stack);
            String id = location.isOrigin() ? "1" : (this.isEnchanted(stack) ? "3" : "2");
            this.addItemDesc(list, id, new Object[0]);
            if (!location.isOrigin()) {
                SupportStructures struct = this.getStructureType(stack);
                if (struct != null) {
                    list.add((ITextComponent)new StringTextComponent(struct.getStructureName().replace("_", " ")));
                }
                this.addItemPosition(list, location);
            }
            this.addItemUse(list, id, new Object[0]);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) || oldStack.func_77952_i() != newStack.func_77952_i();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.field_72995_K && stack.func_77973_b() == this && EntityHelper.isValidPlayer(entity) && !this.isWakeUp(stack)) {
            int cd = this.getCooldown(world, stack);
            if (cd <= 0) {
                this.setCooldown(world, stack, TimeHelper.tickFromSecond(Helper.getRandom(500, 800)));
            } else if (cd == 1) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                boolean success = this.wakeUpMagic(player, stack);
                if (success) {
                    player.func_145747_a(LangKey.MESSAGE_LOST_TABLET_WAKE_UP_SUCCESS.getTranslation().func_150255_a(StyleType.MESSAGE_SPELL.getStyle()));
                } else if (Helper.getRandom(1, 100) < 50) {
                    this.setCooldown(world, stack, TimeHelper.tickFromSecond(Helper.getRandom(1500, 1800)));
                } else {
                    player.func_145747_a(LangKey.MESSAGE_LOST_TABLET_WAKE_UP_FAILED.getTranslation().func_150255_a(StyleType.MESSAGE_SPELL.getStyle()));
                    stack.func_190918_g(1);
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)(Helper.getRandom(0, 1) == 0 ? ModItems.grave_dust : ModItems.dust_of_vanishing), Helper.getRandom(3, 5)));
                }
                player.field_71069_bz.func_75142_b();
            } else if (((Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get()).booleanValue() && TimeHelper.atInterval(entity.field_70173_aa, TimeHelper.tickFromMinute(1))) {
                entity.func_70097_a(ModDamages.BEYOND_THE_GRAVE, 1.0f);
            }
        }
    }

    private DimensionType getWorldTypeForStructure(SupportStructures struct) {
        switch (struct) {
            case FORTRESS: {
                return DimensionType.field_223228_b_;
            }
            case END_CITY: {
                return DimensionType.field_223229_c_;
            }
        }
        return DimensionType.field_223227_a_;
    }

    private boolean wakeUpMagic(ServerPlayerEntity player, ItemStack stack) {
        Location location;
        SupportStructures struct;
        if (Helper.getRandom(1, 100) < 60 - EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.treasure_seeker) * 10) {
            struct = SupportStructures.VILLAGE;
        } else {
            struct = SupportStructures.getRandomStructure(p -> p != SupportStructures.VILLAGE);
            if (struct == null) {
                struct = SupportStructures.VILLAGE;
            }
        }
        ServerWorld world = player.func_71121_q();
        DimensionType dimensionType = this.getWorldTypeForStructure(struct);
        if (world.field_73011_w.func_186058_p() != dimensionType) {
            if (((Boolean)ConfigTombstone.decorative_grave.allowTabletSearchOutsideWorld.get()).booleanValue()) {
                assert (player.func_184102_h() != null);
                world = player.func_184102_h().func_71218_a(dimensionType);
            } else {
                return false;
            }
        }
        if ((location = Helper.findNearestStructure(world, player.func_180425_c(), struct, true)).isOrigin() || !Helper.isValidPos((World)world, location.getPos())) {
            return false;
        }
        boolean isVillage = struct == SupportStructures.VILLAGE;
        ModTriggers.FIND_LOST_TABLET.trigger(player);
        stack.func_196085_b(isVillage ? 1 : 2);
        this.setStructurePos(stack, location);
        this.setStructureType(stack, struct);
        player.field_71069_bz.func_75142_b();
        return true;
    }

    private void setStructureType(ItemStack stack, SupportStructures struct) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setInteger(stack, "structureType", struct.ordinal());
        }
    }

    @Nullable
    private SupportStructures getStructureType(ItemStack stack) {
        if (stack.func_77973_b() == this && NBTStackHelper.hasKeyName(stack, "structureType")) {
            int ordinal = NBTStackHelper.getInteger(stack, "structureType");
            return ordinal < SupportStructures.values().length ? SupportStructures.values()[ordinal] : null;
        }
        return null;
    }

    public boolean isWakeUp(ItemStack stack) {
        return this.getStructureType(stack) != null;
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        return (Boolean)ConfigTombstone.allowed_magic_items.allowLostTablet.get() != false && this.isWakeUp(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.isWakeUp(stack) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        if (!this.isWakeUp(stack)) {
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return true;
    }

    @Override
    protected boolean doEffects(World world, ServerPlayerEntity player, ItemStack stack) {
        Location location = this.getStructurePos(stack);
        if (location.isOrigin() || !Helper.isValidDimension(location.dim)) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_FAILED.getTranslation());
            this.resetStack(world, stack);
            return false;
        }
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !location.isSameDimension(world)) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.getTranslation());
            return false;
        }
        DimensionType dimType = DimensionType.func_186069_a((int)location.dim);
        assert (player.func_184102_h() != null && dimType != null);
        ServerWorld targetWorld = player.func_184102_h().func_71218_a(dimType);
        if (!Helper.isValidPos((World)targetWorld, location.getPos())) {
            player.func_145747_a(LangKey.MESSAGE_TELEPORT_FAILED.getTranslation());
            this.resetStack(world, stack);
            return false;
        }
        Location spawnLoc = Helper.findSpawnForVillage(targetWorld, location.getPos());
        if (spawnLoc.isOrigin()) {
            player.func_145747_a(LangKey.MESSAGE_NO_SPAWN.getTranslation());
            this.resetStack(world, stack);
            return false;
        }
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.setLocation(stack, "structurePos", spawnLoc);
        CallbackHandler.addCallback(1, () -> {
            PlayerEntity newPlayer = (PlayerEntity)Helper.teleportEntity(player, spawnLoc);
            newPlayer.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslation());
            ModTriggers.USE_LOST_TABLET.trigger(player);
        });
        return true;
    }

    private void resetStack(World world, ItemStack stack) {
        this.setCooldown(world, stack, TimeHelper.tickFromMinute(10));
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.removeKeyName(stack, "structurePosX");
        NBTStackHelper.removeKeyName(stack, "structurePosY");
        NBTStackHelper.removeKeyName(stack, "structurePosZ");
        NBTStackHelper.removeKeyName(stack, "structurePosD");
    }

    private void setStructurePos(ItemStack stack, Location location) {
        if (stack.func_77973_b() != this || location.isOrigin()) {
            return;
        }
        NBTStackHelper.setLocation(stack, "structurePos", location);
    }

    public Location getStructurePos(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return Location.ORIGIN;
        }
        return NBTStackHelper.getLocation(stack, "structurePos");
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }
}

