/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.LinkedList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class TeleportationHandler {
    public static Entity teleportEntity(Entity entity, DimensionType targetDimType, double xCoord, double yCoord, double zCoord) {
        return TeleportationHandler.teleportEntity(entity, targetDimType, xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
    }

    public static Entity teleportEntity(Entity entity, DimensionType targetDimType, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        MinecraftServer server;
        if (!entity.field_70170_p.field_72995_K && entity.func_70089_S() && (server = entity.func_184102_h()) != null) {
            DimensionType sourceDimType = entity.field_70170_p.field_73011_w.func_186058_p();
            if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
                return TeleportationHandler.teleportEntity(entity, server, sourceDimType, targetDimType, xCoord, yCoord, zCoord, yaw, pitch);
            }
            Entity lowestRidingEntity = entity.func_184208_bv();
            PassengerHelper passengerHelper = new PassengerHelper(lowestRidingEntity);
            PassengerHelper rider = passengerHelper.getPassenger(entity);
            if (rider == null) {
                return entity;
            }
            passengerHelper.teleport(server, sourceDimType, targetDimType, xCoord, yCoord, zCoord, yaw, pitch);
            passengerHelper.remountRiders();
            passengerHelper.updateClients();
            return rider.entity;
        }
        return entity;
    }

    private static Entity teleportEntity(Entity entity, MinecraftServer server, DimensionType sourceDim, DimensionType targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || entity.field_70128_L) {
            return entity;
        }
        boolean interDimensional = sourceDim != targetDim;
        boolean isPlayer = entity instanceof ServerPlayerEntity;
        if (interDimensional) {
            if (ForgeHooks.onTravelToDimension((Entity)entity, (DimensionType)targetDim)) {
                if (isPlayer) {
                    return TeleportationHandler.teleportPlayerInterdimensional((ServerPlayerEntity)entity, server, server.func_71218_a(targetDim), xCoord, yCoord, zCoord, yaw, pitch);
                }
                return TeleportationHandler.teleportEntityInterdimensional(entity, server.func_71218_a(sourceDim), server.func_71218_a(targetDim), xCoord, yCoord, zCoord, yaw, pitch);
            }
        } else if (isPlayer) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
            player.func_70034_d(yaw);
        } else {
            entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            entity.func_70034_d(yaw);
        }
        return entity;
    }

    private static ServerPlayerEntity teleportPlayerInterdimensional(ServerPlayerEntity player, MinecraftServer server, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        UUID id = player.func_110124_au();
        player.func_200619_a(targetWorld, xCoord, yCoord, zCoord, yaw, pitch);
        return server.func_184103_al().func_177451_a(id);
    }

    private static Entity teleportEntityInterdimensional(Entity entity, ServerWorld sourceWorld, ServerWorld targetWorld, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        DimensionType targetDim = targetWorld.func_201675_m().func_186058_p();
        Vec3d motion = entity.func_213322_ci();
        entity.field_71093_bK = targetDim;
        entity.func_213319_R();
        Entity newEntity = entity.func_200600_R().func_200721_a((World)targetWorld);
        if (newEntity != null) {
            CompoundNBT nbt = new CompoundNBT();
            entity.func_184198_c(nbt);
            nbt.func_82580_o("Dimension");
            newEntity.func_70020_e(nbt);
            newEntity.field_71088_bW = entity.field_71088_bW;
            newEntity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            newEntity.func_213317_d(motion);
            targetWorld.func_217460_e(newEntity);
            sourceWorld.func_82742_i();
            targetWorld.func_82742_i();
        }
        entity.remove(false);
        return newEntity;
    }

    private static class PassengerHelper {
        public Entity entity;
        final LinkedList<PassengerHelper> passengers = new LinkedList();
        double offsetX;
        double offsetY;
        double offsetZ;

        PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.func_184218_aH()) {
                this.offsetX = entity.field_70165_t - entity.func_184187_bx().field_70165_t;
                this.offsetY = entity.field_70163_u - entity.func_184187_bx().field_70163_u;
                this.offsetZ = entity.field_70161_v - entity.func_184187_bx().field_70161_v;
            }
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        void teleport(MinecraftServer server, DimensionType sourceDim, DimensionType targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
            this.entity.func_184226_ay();
            this.entity = TeleportationHandler.teleportEntity(this.entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
        }

        void remountRiders() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.func_184218_aH()) {
                this.entity.func_70012_b(this.entity.field_70165_t + this.offsetX, this.entity.field_70163_u + this.offsetY, this.entity.field_70161_v + this.offsetZ, this.entity.field_70177_z, this.entity.field_70125_A);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.func_184205_a(this.entity, true);
                passenger.remountRiders();
            }
        }

        void updateClients() {
            if (this.entity instanceof ServerPlayerEntity) {
                this.updateClient((ServerPlayerEntity)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(ServerPlayerEntity playerMP) {
            if (this.entity.func_184207_aI()) {
                playerMP.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

