/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.Difficulty;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.OverworldChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.VillageSiegeHandler;

public class CommandTBSiege
extends TombstoneCommand {
    public CommandTBSiege(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbsiege";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.launchSiege((CommandSource)c.getSource()));
        return builder;
    }

    private int launchSiege(CommandSource sender) throws CommandException {
        if (!((Boolean)ConfigTombstone.village_siege.handleVillageSiege.get()).booleanValue()) {
            throw new CommandException(LangKey.MESSAGE_DISABLED.getTranslation());
        }
        ServerWorld world = DimensionManager.getWorld((MinecraftServer)sender.func_197028_i(), (DimensionType)DimensionType.field_223227_a_, (boolean)false, (boolean)false);
        if (world == null) {
            throw new CommandException(LangKey.MESSAGE_UNLOADED_DIMENSION.getTranslation());
        }
        if (world.func_72912_H().func_176130_y() == Difficulty.PEACEFUL) {
            throw new CommandException(LangKey.MESSAGE_DIFFICULTY_PEACEFUL.getTranslation());
        }
        if (world.func_72935_r()) {
            throw new CommandException(LangKey.MESSAGE_ONLY_AT_NIGHT.getTranslation());
        }
        ChunkGenerator chunkGenerator = world.func_72863_F().func_201711_g();
        if (!(chunkGenerator instanceof OverworldChunkGenerator)) {
            throw new CommandException((ITextComponent)new StringTextComponent("The Overworld chunk generator is not the vanilla one"));
        }
        VillageSiege villageSiege = ((OverworldChunkGenerator)chunkGenerator).field_225495_n;
        if (villageSiege instanceof VillageSiegeHandler.CustomVillageSiege) {
            VillageSiegeHandler.CustomVillageSiege currentSiege = (VillageSiegeHandler.CustomVillageSiege)villageSiege;
            switch (currentSiege.field_75536_c) {
                case SIEGE_START: 
                case SPAWN_MOBS: {
                    throw new CommandException(LangKey.MESSAGE_START_SIEGE_FAILED.getTranslation());
                }
                case SIEGE_END: {
                    currentSiege.hasFailedTrySiege = false;
                    currentSiege.field_75536_c = VillageSiegeHandler.SiegeState.SIEGE_START;
                    this.sendMessage(sender, LangKey.MESSAGE_START_SIEGE_SUCCESS.getTranslation(), false);
                }
            }
        }
        return 1;
    }
}

