/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.ThreadedBackup;
import ovh.corail.tombstone.registry.ModItems;

public class CommandTBReviveFamiliar
extends TombstoneCommand {
    public CommandTBReviveFamiliar(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbrevivefamiliar";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.showUsage((CommandSource)c.getSource()));
        builder.then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.reviveFamiliar((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"))));
        return builder;
    }

    private int reviveFamiliar(CommandSource sender, ServerPlayerEntity player) {
        this.checkAlive((Entity)player);
        this.checkNotSpectator((PlayerEntity)player);
        CompoundNBT petTag = this.getLastSave(sender, (PlayerEntity)player);
        ItemStack receptacle = ItemStack.field_190927_a;
        if (petTag != null) {
            receptacle = new ItemStack((IItemProvider)ModItems.familiar_receptacle);
            receptacle.func_196082_o().func_218657_a("dead_pet", (INBT)petTag);
        } else {
            receptacle = (ItemStack)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(invent -> IntStream.range(0, invent.getSlots()).mapToObj(arg_0 -> ((IItemHandler)invent).getStackInSlot(arg_0)).filter(ModItems.familiar_receptacle::containSoul).findFirst().orElse(ItemStack.field_190927_a)).orElse((Object)ItemStack.field_190927_a);
        }
        if (receptacle.func_190926_b()) {
            throw new CommandException(LangKey.MESSAGE_NO_SAVE_TO_RESTORE.getTranslation());
        }
        boolean success = ModItems.familiar_receptacle.revive((PlayerEntity)player, player.func_180425_c(), receptacle);
        LangKey langKey = success ? LangKey.MESSAGE_BRING_BACK_TO_LIFE : LangKey.MESSAGE_CANT_REVIVE_FAMILIAR;
        player.func_145747_a(langKey.getTranslationWithStyle(success ? StyleType.MESSAGE_SPELL : StyleType.COLOR_OFF, LangKey.MESSAGE_YOUR_FAMILIAR.getTranslation()));
        if (sender.func_197022_f() != player) {
            this.sendMessage(sender, langKey.getTranslationWithStyle(success ? StyleType.MESSAGE_SPELL : StyleType.COLOR_OFF, LangKey.MESSAGE_FAMILIAR_OF.getTranslation(player.func_200200_C_())), false);
        }
        receptacle.func_190918_g(1);
        player.field_71069_bz.func_75142_b();
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private CompoundNBT getLastSave(CommandSource sender, PlayerEntity player) {
        File saveFolder = new File(sender.func_197028_i().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "tombstone/saved_familiars/" + player.func_110124_au());
        if (!saveFolder.exists()) {
            return null;
        }
        File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
        if (saveFiles == null) return null;
        if (saveFiles.length == 0) {
            return null;
        }
        File file = Stream.of(saveFiles).max(File::compareTo).orElse(null);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            CompoundNBT nbt = JsonToNBT.func_180713_a((String)reader.readLine());
            reader.close();
            if (nbt.func_150296_c().isEmpty()) return null;
            file.delete();
            CompoundNBT compoundNBT = nbt;
            return compoundNBT;
        }
        catch (CommandSyntaxException | IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveFamiliar(MinecraftServer server, UUID ownerId, CompoundNBT tag, String saveName) {
        File saveFolder = new File(server.func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "tombstone/saved_familiars/" + ownerId);
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            ModTombstone.LOGGER.info("The backup folder for familiars cannot be created");
            return;
        }
        String dateString = new SimpleDateFormat("yyyyMMdd-hhmmss", Locale.US).format(new Date());
        File accessedFile = new File(saveFolder, dateString + "_" + saveName + ".save");
        ThreadedBackup.INSTANCE.queueBackup(() -> {
            block16: {
                try (FileWriter writer = new FileWriter(accessedFile);){
                    writer.write(tag.toString());
                    writer.close();
                    File[] matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"));
                    if (matchingFiles == null || matchingFiles.length <= 5) break block16;
                    int diff = matchingFiles.length - 5;
                    Arrays.sort(matchingFiles, Comparator.comparingLong(File::lastModified));
                    int num = 0;
                    for (File file2 : matchingFiles) {
                        if (num >= diff) {
                            break;
                        }
                        file2.delete();
                        ++num;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        });
    }
}

