/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public enum GraveModel implements IStringSerializable
{
    GRAVE_SIMPLE("grave_simple"),
    GRAVE_NORMAL("grave_normal"),
    GRAVE_CROSS("grave_cross"),
    TOMBSTONE("tombstone"),
    SUBARAKI_GRAVE("subaraki_grave", true);

    private final String name;
    private final boolean onlyContributor;
    private final Map<Direction, VoxelShape> collisions = new HashMap<Direction, VoxelShape>();
    private static final VoxelShape ground_bounds;
    private static final VoxelShape subaraki_ground_bounds;

    private GraveModel(String name) {
        this(name, false);
    }

    private GraveModel(String name, boolean onlyContributor) {
        this.name = name;
        this.onlyContributor = onlyContributor;
    }

    public GraveModel getPrevious() {
        return GraveModel.byId(this.ordinal() > 0 ? this.ordinal() - 1 : GraveModel.values().length - 1);
    }

    public GraveModel getNext() {
        return GraveModel.byId(this.ordinal() == GraveModel.values().length - 1 ? 0 : this.ordinal() + 1);
    }

    public boolean isOnlyContributor() {
        return this.onlyContributor;
    }

    public final VoxelShape getShape(Direction facing) {
        return this.collisions.get(facing);
    }

    public static GraveModel byId(int id) {
        return id >= 0 && id < GraveModel.values().length ? GraveModel.values()[id] : GraveModel.getDefault();
    }

    public static GraveModel getDefault() {
        return GRAVE_SIMPLE;
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    private VoxelShape getVoxelForDirection(Direction direction, double x1, double y1, double z1, double x2, double y2, double z2) {
        double oldX1 = x1;
        double oldX2 = x2;
        double oldZ1 = z1;
        double oldZ2 = z2;
        switch (direction) {
            case SOUTH: {
                z1 = 1.0 - oldZ2;
                z2 = 1.0 - oldZ1;
                break;
            }
            case WEST: {
                x1 = oldZ1;
                x2 = oldZ2;
                z1 = oldX1;
                z2 = oldX2;
                break;
            }
            case EAST: {
                x1 = 1.0 - oldZ2;
                x2 = 1.0 - oldZ1;
                z1 = oldX1;
                z2 = oldX2;
                break;
            }
        }
        return VoxelShapes.func_197873_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    private void createShape() {
        switch (this) {
            case GRAVE_NORMAL: {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.collisions.put(direction, VoxelShapes.func_216384_a((VoxelShape)ground_bounds, (VoxelShape[])new VoxelShape[]{this.getVoxelForDirection(direction, 0.1875, 0.0625, 0.0, 0.8125, 0.25, 1.0), this.getVoxelForDirection(direction, 0.25, 0.25, 0.0625, 0.75, 0.3125, 0.875), this.getVoxelForDirection(direction, 0.1875, 0.25, 0.875, 0.8125, 0.8125, 1.0), this.getVoxelForDirection(direction, 0.25, 0.8125, 0.875, 0.75, 0.875, 1.0)}).func_197753_c());
                }
                break;
            }
            case GRAVE_CROSS: {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.collisions.put(direction, VoxelShapes.func_216384_a((VoxelShape)ground_bounds, (VoxelShape[])new VoxelShape[]{this.getVoxelForDirection(direction, 0.40625, 0.125, 0.6875, 0.59375, 0.9375, 0.875), this.getVoxelForDirection(direction, 0.21875, 0.5625, 0.6875, 0.78125, 0.75, 0.875), this.getVoxelForDirection(direction, 0.28125, 0.0625, 0.5625, 0.71875, 0.125, 1.0), this.getVoxelForDirection(direction, 0.34375, 0.125, 0.625, 0.65625, 0.1875, 0.9375)}).func_197753_c());
                }
                break;
            }
            case TOMBSTONE: {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.collisions.put(direction, VoxelShapes.func_216384_a((VoxelShape)ground_bounds, (VoxelShape[])new VoxelShape[]{this.getVoxelForDirection(direction, 0.0625, 0.0625, 0.0625, 0.9375, 0.09375, 0.4375), this.getVoxelForDirection(direction, 0.0625, 0.09375, 0.1875, 0.9375, 0.125, 0.4375), this.getVoxelForDirection(direction, 0.84375, 0.125, 0.28125, 0.90625, 0.59375, 0.34375), this.getVoxelForDirection(direction, 0.09375, 0.125, 0.28125, 0.15625, 0.59375, 0.34375), this.getVoxelForDirection(direction, 0.0625, 0.0625, 0.4375, 0.9375, 0.59375, 0.9375), this.getVoxelForDirection(direction, 0.03125, 0.59375, 0.21875, 0.96875, 0.625, 0.96875), this.getVoxelForDirection(direction, 0.0625, 0.625, 0.25, 0.9375, 0.64375, 0.9375)}).func_197753_c());
                }
                break;
            }
            case SUBARAKI_GRAVE: {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.collisions.put(direction, VoxelShapes.func_197872_a((VoxelShape)subaraki_ground_bounds, (VoxelShape)this.getVoxelForDirection(direction, 0.25, 0.4375, 0.375, 0.75, 0.9375, 0.625)).func_197753_c());
                }
                break;
            }
            default: {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.collisions.put(direction, VoxelShapes.func_216384_a((VoxelShape)ground_bounds, (VoxelShape[])new VoxelShape[]{this.getVoxelForDirection(direction, 0.1875, 0.0625, 0.8125, 0.8125, 0.8125, 1.0), this.getVoxelForDirection(direction, 0.25, 0.8125, 0.8125, 0.75, 0.875, 1.0)}).func_197753_c());
                }
            }
        }
    }

    static {
        ground_bounds = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
        subaraki_ground_bounds = VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375), (VoxelShape[])new VoxelShape[]{VoxelShapes.func_197873_a((double)0.125, (double)0.0625, (double)0.125, (double)0.875, (double)0.125, (double)0.875), VoxelShapes.func_197873_a((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)0.375, (double)0.75), VoxelShapes.func_197873_a((double)0.1875, (double)0.375, (double)0.1875, (double)0.8125, (double)0.4375, (double)0.8125), VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)0.1875, (double)0.125), VoxelShapes.func_197873_a((double)0.875, (double)0.0, (double)0.875, (double)1.0, (double)0.1875, (double)1.0), VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.875, (double)0.125, (double)0.1875, (double)1.0), VoxelShapes.func_197873_a((double)0.875, (double)0.0, (double)0.0, (double)1.0, (double)0.1875, (double)0.125)});
        for (GraveModel model : GraveModel.values()) {
            model.createShape();
        }
    }
}

