/*
 * Decompiled with CFR 0.152.
 */
package tehnut.harvest;

import com.google.common.base.Joiner;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import tehnut.harvest.Crop;
import tehnut.harvest.Harvest;
import tehnut.harvest.IReplantHandler;

public class ReplantHandlers {
    public static final IReplantHandler CONFIG = (world, pos, state, player, tileEntity) -> {
        Crop crop = Harvest.config.getCrops().stream().filter(c -> c.test(state)).findFirst().orElse(null);
        if (crop == null) {
            Harvest.debug("No crop found for state {}", state);
            Harvest.debug("Valid crops {}", Joiner.on((String)" | ").join(Harvest.config.getCrops()));
            return ActionResultType.PASS;
        }
        List drops = Block.func_220077_a((BlockState)state, (ServerWorld)world, (BlockPos)pos, (TileEntity)tileEntity, (Entity)player, (ItemStack)player.func_184586_b(Hand.MAIN_HAND));
        boolean foundSeed = false;
        for (ItemStack drop : drops) {
            if (!drop.func_77973_b().func_206844_a(Harvest.SEED_TAG)) continue;
            foundSeed = true;
            drop.func_190918_g(1);
            break;
        }
        if (foundSeed) {
            drops.forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
            world.func_175656_a(pos, state.func_177230_c().func_176223_P());
            return ActionResultType.SUCCESS;
        }
        Harvest.debug("Failed to find a seed for {}", state);
        return ActionResultType.FAIL;
    };
}

