/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules.passive;

import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;

@JAOPCAModule
public class DustsModule
implements IModule {
    private final IForm dustForm = JAOPCAApi.instance().newForm(this, "dusts", JAOPCAApi.instance().itemFormType()).setMaterialTypes(MaterialType.NON_DUSTS);

    @Override
    public String getName() {
        return "dusts";
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.dustForm.toRequest());
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        JAOPCAApi api = JAOPCAApi.instance();
        for (IMaterial material : this.dustForm.getMaterials()) {
            if (!ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)material.getType()))) continue;
            api.registerFurnaceRecipe(new ResourceLocation("jaopca", "dusts.to_material." + material.getName()), api.itemFormType().getMaterialFormInfo(this.dustForm, material), api.miscHelper().getTagLocation(material.getType().getFormName(), material.getName()), 1, 0.1f, 200);
        }
    }
}

