/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.base.Predicates;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.objectweb.asm.Type;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleData;

public class ModuleHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type JAOPCA_MODULE = Type.getType(JAOPCAModule.class);
    private static final TreeMap<String, IModule> MODULES = new TreeMap();
    private static final TreeMap<IModule, ModuleData> MODULE_DATAS = new TreeMap();

    private ModuleHandler() {
    }

    public static Map<String, IModule> getModuleMap() {
        return MODULES;
    }

    public static Collection<IModule> getModules() {
        return MODULES.values();
    }

    public static Map<IModule, ModuleData> getModuleDataMap() {
        return MODULE_DATAS;
    }

    public static ModuleData getModuleData(String name) {
        return MODULE_DATAS.get(MODULES.get(name));
    }

    public static ModuleData getModuleData(IModule module) {
        return MODULE_DATAS.get(module);
    }

    public static Collection<ModuleData> getModuleDatas() {
        return MODULE_DATAS.values();
    }

    public static void findModules() {
        MODULES.clear();
        List annotationData = ModList.get().getAllScanData().stream().flatMap(data -> data.getAnnotations().stream()).filter(data -> JAOPCA_MODULE.equals((Object)data.getAnnotationType())).collect(Collectors.toList());
        for (ModFileScanData.AnnotationData aData : annotationData) {
            List deps = (List)aData.getAnnotationData().get("modDependencies");
            String className = aData.getClassType().getClassName();
            if (deps != null && deps.stream().filter(Predicates.notNull()).anyMatch(ModuleHandler::isModVersionNotLoaded)) {
                LOGGER.info("Module {} has missing mod dependencies, skipping", (Object)className);
                continue;
            }
            try {
                IModule module;
                Class<?> moduleClass = Class.forName(className);
                Class<IModule> moduleInstanceClass = moduleClass.asSubclass(IModule.class);
                try {
                    Method method = moduleClass.getMethod("getInstance", new Class[0]);
                    module = (IModule)method.invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    module = moduleInstanceClass.newInstance();
                }
                if (MODULES.putIfAbsent(module.getName(), module) != null) {
                    LOGGER.fatal("Module name conflict: {} for {} and {}", (Object)module.getName(), MODULES.get(module.getName()).getClass(), module.getClass());
                    continue;
                }
                ModuleData mData = new ModuleData(module);
                MODULE_DATAS.put(module, mData);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.fatal("Unable to load module {}", (Object)className, (Object)e);
            }
        }
    }

    static boolean isModVersionNotLoaded(String dep) {
        VersionRange versionRange;
        ModList modList = ModList.get();
        int separatorIndex = dep.lastIndexOf(64);
        String modId = dep.substring(0, separatorIndex == -1 ? dep.length() : separatorIndex);
        String spec = separatorIndex == -1 ? "0" : dep.substring(separatorIndex + 1, dep.length());
        try {
            versionRange = VersionRange.createFromVersionSpec((String)spec);
        }
        catch (InvalidVersionSpecificationException e) {
            LOGGER.warn("Unable to parse version spec {} for mod id {}", (Object)spec, (Object)modId, (Object)e);
            return true;
        }
        if (modList.isLoaded(modId)) {
            return !versionRange.containsVersion(((ModContainer)modList.getModContainerById(modId).get()).getModInfo().getVersion());
        }
        return true;
    }

    public static void computeValidMaterials() {
        List<IMaterial> materials;
        for (ModuleData data : ModuleHandler.getModuleDatas()) {
            materials = MaterialHandler.getMaterials().stream().filter(data.getModule().isPassive() ? material -> data.getConfigPassiveMaterialWhitelist().contains(material.getName()) : data::isMaterialModuleValid).collect(Collectors.toList());
            for (IMaterial material2 : materials) {
                if (data.isMaterialDependencyValid(material2)) {
                    data.addDependencyRequestedMaterial(material2);
                    continue;
                }
                data.addRejectedMaterial(material2);
            }
        }
        for (ModuleData data : ModuleHandler.getModuleDatas()) {
            materials = MaterialHandler.getMaterials().stream().filter(data::isMaterialValid).collect(Collectors.toList());
            data.setMaterials(materials);
        }
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        for (IModule module : ModuleHandler.getModules()) {
            module.onCommonSetup(ModuleHandler.getModuleData(module), event);
        }
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        for (IModule module : ModuleHandler.getModules()) {
            module.onClientSetup(ModuleHandler.getModuleData(module), event);
        }
    }

    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        for (IModule module : ModuleHandler.getModules()) {
            module.onInterModEnqueue(ModuleHandler.getModuleData(module), event);
        }
    }

    public static void onRecipeInjectComplete(IResourceManager resourceManager) {
        for (IModule module : ModuleHandler.getModules()) {
            module.onRecipeInjectComplete(ModuleHandler.getModuleData(module), resourceManager);
        }
    }
}

