/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.fluids.FluidFormType;

public class JAOPCAFluid
extends Fluid
implements IMaterialFormFluid {
    public static final float EIGHT_NINTHS = 0.8888889f;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>> CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey>(200){

            protected void rehash(int newN) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    private final IForm form;
    private final IMaterial material;
    protected final IFluidFormSettings settings;
    protected final StateContainer<Fluid, IFluidState> field_207202_e;
    private final Map<IFluidState, VoxelShape> shapeMap = new IdentityHashMap<IFluidState, VoxelShape>();
    protected final int maxLevel;
    protected final IntegerProperty levelProperty;
    protected BlockRenderLayer renderLayer;
    protected OptionalInt tickRate = OptionalInt.empty();
    protected OptionalDouble explosionResistance = OptionalDouble.empty();
    protected Optional<Boolean> canSourcesMultiply = Optional.empty();
    protected Optional<Boolean> canFluidBeDisplaced = Optional.empty();
    protected OptionalInt levelDecreasePerBlock = OptionalInt.empty();

    public JAOPCAFluid(IForm form, IMaterial material, IFluidFormSettings settings) {
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.maxLevel = settings.getMaxLevelFunction().applyAsInt(material);
        this.levelProperty = IntegerProperty.func_177719_a((String)"level", (int)1, (int)(this.maxLevel + 1));
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_207184_a((StateContainer.Builder<Fluid, IFluidState>)builder);
        this.field_207202_e = builder.func_206893_a(FluidState::new);
        this.func_207183_f((IFluidState)this.field_207202_e.func_177621_b());
        this.renderLayer = settings.getRenderLayer();
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    @Override
    public IntegerProperty getLevelProperty() {
        return this.levelProperty;
    }

    protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
        if (this.levelProperty != null) {
            builder.func_206894_a(new IProperty[]{this.levelProperty});
        }
    }

    public StateContainer<Fluid, IFluidState> func_207182_e() {
        return this.field_207202_e;
    }

    public BlockRenderLayer func_180664_k() {
        return this.renderLayer;
    }

    public int func_205569_a(IWorldReader world) {
        if (!this.tickRate.isPresent()) {
            this.tickRate = OptionalInt.of(this.settings.getTickRateFunction().applyAsInt(this.material));
        }
        return this.tickRate.getAsInt();
    }

    protected float func_210195_d() {
        if (!this.explosionResistance.isPresent()) {
            this.explosionResistance = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.material));
        }
        return (float)this.explosionResistance.getAsDouble();
    }

    protected boolean canSourcesMultiply() {
        if (!this.canSourcesMultiply.isPresent()) {
            this.canSourcesMultiply = Optional.of(this.settings.getCanSourcesMultiplyFunction().test(this.material));
        }
        return this.canSourcesMultiply.get();
    }

    protected boolean func_215665_a(IFluidState fluidState, IBlockReader world, BlockPos pos, Fluid fluid, Direction face) {
        return face == Direction.DOWN && !this.func_207187_a(fluid);
    }

    protected int getLevelDecreasePerBlock(IWorldReader world) {
        if (!this.levelDecreasePerBlock.isPresent()) {
            this.levelDecreasePerBlock = OptionalInt.of(this.settings.getLevelDecreasePerBlockFunction().applyAsInt(this.material));
        }
        return this.levelDecreasePerBlock.getAsInt();
    }

    protected FluidAttributes createAttributes() {
        return this.settings.getFluidAttributesCreator().create(this, this.settings);
    }

    public Item func_204524_b() {
        return FluidFormType.INSTANCE.getMaterialFormInfo(this.form, this.material).getBucketItem();
    }

    protected BlockState func_204527_a(IFluidState fluidState) {
        IMaterialFormFluidBlock materialFormBlock = FluidFormType.INSTANCE.getMaterialFormInfo(this.form, this.material).getMaterialFormFluidBlock();
        IntegerProperty blockLevelProperty = materialFormBlock.getLevelProperty();
        int fluidLevel = (Integer)fluidState.func_177229_b((IProperty)this.levelProperty);
        int blockLevel = fluidLevel > this.maxLevel ? this.maxLevel : this.maxLevel - fluidLevel;
        return (BlockState)materialFormBlock.asBlock().func_176223_P().func_206870_a((IProperty)blockLevelProperty, (Comparable)Integer.valueOf(blockLevel));
    }

    @Override
    public IFluidState getSourceState() {
        return (IFluidState)this.func_207188_f().func_206870_a((IProperty)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel));
    }

    protected Vec3d func_215663_a(IBlockReader world, BlockPos pos, IFluidState state) {
        double x = 0.0;
        double y = 0.0;
        try (BlockPos.PooledMutableBlockPos mutablePos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (Direction offset : Direction.Plane.HORIZONTAL) {
                mutablePos.func_189533_g((Vec3i)pos).func_189536_c(offset);
                IFluidState offsetState = world.func_204610_c((BlockPos)mutablePos);
                if (!this.isSameOrEmpty(offsetState)) continue;
                float offsetHeight = offsetState.func_223408_f();
                float heightDiff = 0.0f;
                if (offsetHeight == 0.0f) {
                    BlockPos posDown;
                    IFluidState belowState;
                    if (!world.func_180495_p((BlockPos)mutablePos).func_185904_a().func_76230_c() && this.isSameOrEmpty(belowState = world.func_204610_c(posDown = mutablePos.func_177977_b())) && (offsetHeight = belowState.func_223408_f()) > 0.0f) {
                        heightDiff = state.func_223408_f() - (offsetHeight - 0.8888889f);
                    }
                } else if (offsetHeight > 0.0f) {
                    heightDiff = state.func_223408_f() - offsetHeight;
                }
                if (heightDiff == 0.0f) continue;
                x += (double)((float)offset.func_82601_c() * heightDiff);
                y += (double)((float)offset.func_82599_e() * heightDiff);
            }
            Vec3d flow = new Vec3d(x, 0.0, y);
            if ((Integer)state.func_177229_b((IProperty)this.levelProperty) == 0) {
                for (Direction offset : Direction.Plane.HORIZONTAL) {
                    mutablePos.func_189533_g((Vec3i)pos).func_189536_c(offset);
                    if (!this.causesDownwardCurrent(world, (BlockPos)mutablePos, offset) && !this.causesDownwardCurrent(world, mutablePos.func_177984_a(), offset)) continue;
                    flow = flow.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
                    break;
                }
            }
            Iterator iterator = flow.func_72432_b();
            return iterator;
        }
    }

    private boolean isSameOrEmpty(IFluidState otherState) {
        return otherState.func_206888_e() || otherState.func_206886_c().func_207187_a((Fluid)this);
    }

    protected boolean causesDownwardCurrent(IBlockReader world, BlockPos pos, Direction face) {
        BlockState blockState = world.func_180495_p(pos);
        IFluidState fluidState = world.func_204610_c(pos);
        return !fluidState.func_206886_c().func_207187_a((Fluid)this) && (face == Direction.UP || blockState.func_185904_a() != Material.field_151588_w && blockState.func_224755_d(world, pos, face));
    }

    protected void flowAround(IWorld world, BlockPos pos, IFluidState fluidState) {
        if (!fluidState.func_206888_e()) {
            BlockState blockState = world.func_180495_p(pos);
            BlockPos downPos = pos.func_177977_b();
            BlockState downBlockState = world.func_180495_p(downPos);
            IFluidState newFluidState = this.calculateCorrectState((IWorldReader)world, downPos, downBlockState);
            if (this.canFlow((IBlockReader)world, pos, blockState, Direction.DOWN, downPos, downBlockState, world.func_204610_c(downPos), newFluidState.func_206886_c())) {
                this.flowInto(world, downPos, downBlockState, Direction.DOWN, newFluidState);
                if (this.getAdjacentSourceCount((IWorldReader)world, pos) >= 3) {
                    this.flowAdjacent(world, pos, fluidState, blockState);
                }
            } else if (fluidState.func_206889_d() || !this.canFlowDown((IBlockReader)world, newFluidState.func_206886_c(), pos, blockState, downPos, downBlockState)) {
                this.flowAdjacent(world, pos, fluidState, blockState);
            }
        }
    }

    protected void flowAdjacent(IWorld world, BlockPos pos, IFluidState fluidState, BlockState blockState) {
        int i = fluidState.func_206882_g() - this.getLevelDecreasePerBlock((IWorldReader)world);
        if (i > 0) {
            Map<Direction, IFluidState> map = this.calculateAdjacentStates((IWorldReader)world, pos, blockState);
            for (Map.Entry<Direction, IFluidState> entry : map.entrySet()) {
                BlockState offsetBlockState;
                Direction direction = entry.getKey();
                IFluidState offsetFluidState = entry.getValue();
                BlockPos offsetPos = pos.func_177972_a(direction);
                if (!this.canFlow((IBlockReader)world, pos, blockState, direction, offsetPos, offsetBlockState = world.func_180495_p(offsetPos), world.func_204610_c(offsetPos), offsetFluidState.func_206886_c())) continue;
                this.flowInto(world, offsetPos, offsetBlockState, direction, offsetFluidState);
            }
        }
    }

    protected IFluidState calculateCorrectState(IWorldReader world, BlockPos pos, BlockState blockState) {
        BlockPos upPos;
        BlockState upBlockState;
        IFluidState upFluidState;
        int i = 0;
        int j = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(direction);
            BlockState offsetBlockState = world.func_180495_p(offsetPos);
            IFluidState offsetFluidState = offsetBlockState.func_204520_s();
            if (!offsetFluidState.func_206886_c().func_207187_a((Fluid)this) || !this.doShapesFillSquare(direction, (IBlockReader)world, pos, blockState, offsetPos, offsetBlockState)) continue;
            if (offsetFluidState.func_206889_d()) {
                ++j;
            }
            i = Math.max(i, offsetFluidState.func_206882_g());
        }
        if (this.canSourcesMultiply() && j >= 2) {
            BlockState blockstate1 = world.func_180495_p(pos.func_177977_b());
            IFluidState ifluidstate1 = blockstate1.func_204520_s();
            if (blockstate1.func_185904_a().func_76220_a() || this.isSameSource(ifluidstate1)) {
                return (IFluidState)this.func_207188_f().func_206870_a((IProperty)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel));
            }
        }
        if (!(upFluidState = (upBlockState = world.func_180495_p(upPos = pos.func_177984_a())).func_204520_s()).func_206888_e() && upFluidState.func_206886_c().func_207187_a((Fluid)this) && this.doShapesFillSquare(Direction.UP, (IBlockReader)world, pos, blockState, upPos, upBlockState)) {
            return (IFluidState)this.func_207188_f().func_206870_a((IProperty)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel + 1));
        }
        int k = i - this.getLevelDecreasePerBlock(world);
        if (k <= 0) {
            return Fluids.field_204541_a.func_207188_f();
        }
        return (IFluidState)this.func_207188_f().func_206870_a((IProperty)this.levelProperty, (Comparable)Integer.valueOf(k));
    }

    protected boolean doShapesFillSquare(Direction direction, IBlockReader world, BlockPos fromPos, BlockState fromBlockState, BlockPos toPos, BlockState toBlockState) {
        VoxelShape toShape;
        VoxelShape fromShape;
        boolean flag;
        Block.RenderSideCacheKey cacheKey;
        Object2ByteLinkedOpenHashMap<Block.RenderSideCacheKey> cache = !fromBlockState.func_177230_c().func_208619_r() && !toBlockState.func_177230_c().func_208619_r() ? CACHE.get() : null;
        if (cache != null) {
            cacheKey = new Block.RenderSideCacheKey(fromBlockState, toBlockState, direction);
            byte b0 = cache.getAndMoveToFirst((Object)cacheKey);
            if (b0 != 127) {
                return b0 != 0;
            }
        } else {
            cacheKey = null;
        }
        boolean bl = flag = !VoxelShapes.func_204642_b((VoxelShape)(fromShape = fromBlockState.func_196952_d(world, fromPos)), (VoxelShape)(toShape = toBlockState.func_196952_d(world, toPos)), (Direction)direction);
        if (cache != null) {
            if (cache.size() == 200) {
                cache.removeLastByte();
            }
            cache.putAndMoveToFirst((Object)cacheKey, (byte)(flag ? 1 : 0));
        }
        return flag;
    }

    protected void flowInto(IWorld world, BlockPos pos, BlockState blockState, Direction direction, IFluidState fluidState) {
        if (blockState.func_177230_c() instanceof ILiquidContainer) {
            ((ILiquidContainer)blockState.func_177230_c()).func_204509_a(world, pos, blockState, fluidState);
        } else {
            if (!blockState.isAir((IBlockReader)world, pos)) {
                this.beforeReplacingBlock(world, pos, blockState);
            }
            world.func_180501_a(pos, fluidState.func_206883_i(), 3);
        }
    }

    protected void beforeReplacingBlock(IWorld world, BlockPos pos, BlockState blockState) {
        TileEntity tile = blockState.hasTileEntity() ? world.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)blockState, (World)world.func_201672_e(), (BlockPos)pos, (TileEntity)tile);
    }

    protected static short getPosKey(BlockPos pos, BlockPos otherPos) {
        int dx = otherPos.func_177958_n() - pos.func_177958_n();
        int dz = otherPos.func_177952_p() - pos.func_177952_p();
        return (short)((dx + 128 & 0xFF) << 8 | dz + 128 & 0xFF);
    }

    protected Map<Direction, IFluidState> calculateAdjacentStates(IWorldReader world, BlockPos pos, BlockState blockState) {
        int i = 1000;
        EnumMap<Direction, IFluidState> map = new EnumMap<Direction, IFluidState>(Direction.class);
        Short2ObjectOpenHashMap stateMap = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap canFlowDownMap = new Short2BooleanOpenHashMap();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(direction);
            short key = JAOPCAFluid.getPosKey(pos, offsetPos);
            Pair offsetState = (Pair)stateMap.computeIfAbsent(key, k -> {
                BlockState offsetBlockState = world.func_180495_p(offsetPos);
                return Pair.of((Object)offsetBlockState, (Object)offsetBlockState.func_204520_s());
            });
            BlockState offsetBlockState = (BlockState)offsetState.getLeft();
            IFluidState offsetFluidState = (IFluidState)offsetState.getRight();
            IFluidState newOffsetFluidState = this.calculateCorrectState(world, offsetPos, offsetBlockState);
            if (!this.canFlowSource((IBlockReader)world, newOffsetFluidState.func_206886_c(), pos, blockState, direction, offsetPos, offsetBlockState, offsetFluidState)) continue;
            boolean flag = canFlowDownMap.computeIfAbsent(key, k -> {
                BlockPos offsetDownPos = offsetPos.func_177977_b();
                BlockState offsetDownState = world.func_180495_p(offsetDownPos);
                return this.canFlowDown((IBlockReader)world, this, offsetPos, offsetBlockState, offsetDownPos, offsetDownState);
            });
            int j = 0;
            if (!flag) {
                j = this.getFlowDistance(world, offsetPos, 1, direction.func_176734_d(), offsetBlockState, pos, (Short2ObjectMap<Pair<BlockState, IFluidState>>)stateMap, (Short2BooleanMap)canFlowDownMap);
            }
            if (j < i) {
                map.clear();
            }
            if (j > i) continue;
            map.put(direction, newOffsetFluidState);
            i = j;
        }
        return map;
    }

    protected int getFlowDistance(IWorldReader world, BlockPos pos, int distance, Direction fromDirection, BlockState blockState, BlockPos startPos, Short2ObjectMap<Pair<BlockState, IFluidState>> stateMap, Short2BooleanMap canFlowDownMap) {
        int i = 1000;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int j;
            IFluidState offsetFluidstate;
            short key;
            Pair pair;
            BlockState offsetBlockState;
            BlockPos offsetPos;
            if (direction == fromDirection || !this.canFlowSource((IBlockReader)world, this, pos, blockState, direction, offsetPos = pos.func_177972_a(direction), offsetBlockState = (BlockState)(pair = (Pair)stateMap.computeIfAbsent(key = JAOPCAFluid.getPosKey(startPos, offsetPos), k -> {
                BlockState offsetBlockState = world.func_180495_p(offsetPos);
                return Pair.of((Object)offsetBlockState, (Object)offsetBlockState.func_204520_s());
            })).getLeft(), offsetFluidstate = (IFluidState)pair.getRight())) continue;
            boolean flag = canFlowDownMap.computeIfAbsent(key, k -> {
                BlockPos offsetDownPos = offsetPos.func_177977_b();
                BlockState offsetDownState = world.func_180495_p(offsetDownPos);
                return this.canFlowDown((IBlockReader)world, this, offsetPos, offsetBlockState, offsetDownPos, offsetDownState);
            });
            if (flag) {
                return distance;
            }
            if (distance >= this.getSlopeFindDistance(world) || (j = this.getFlowDistance(world, offsetPos, distance + 1, direction.func_176734_d(), offsetBlockState, startPos, stateMap, canFlowDownMap)) >= i) continue;
            i = j;
        }
        return i;
    }

    protected boolean isSameSource(IFluidState fluidState) {
        return fluidState.func_206886_c().func_207187_a((Fluid)this) && fluidState.func_206889_d();
    }

    protected int getSlopeFindDistance(IWorldReader world) {
        return JAOPCAFluid.ceilDiv(JAOPCAFluid.ceilDiv(this.maxLevel, this.getLevelDecreasePerBlock(world)), 2);
    }

    protected int getAdjacentSourceCount(IWorldReader world, BlockPos pos) {
        int count = 0;
        for (Direction offset : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(offset);
            IFluidState offsetState = world.func_204610_c(offsetPos);
            if (!this.isSameSource(offsetState)) continue;
            ++count;
        }
        return count;
    }

    protected boolean canFlowIntoBlock(IBlockReader world, BlockPos pos, BlockState blockState, Fluid fluid) {
        Block block = blockState.func_177230_c();
        if (block instanceof ILiquidContainer) {
            return ((ILiquidContainer)block).func_204510_a(world, pos, blockState, fluid);
        }
        if (block instanceof DoorBlock || block.func_203417_a(BlockTags.field_219753_V) || block == Blocks.field_150468_ap || block == Blocks.field_196608_cF || block == Blocks.field_203203_C) {
            return false;
        }
        Material blockMaterial = blockState.func_185904_a();
        return blockMaterial != Material.field_151567_E && blockMaterial != Material.field_189963_J && blockMaterial != Material.field_203243_f && blockMaterial != Material.field_204868_h && !blockMaterial.func_76230_c();
    }

    protected boolean canFlow(IBlockReader world, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, IFluidState toFluidState, Fluid fluid) {
        return toFluidState.func_215677_a(world, toPos, fluid, direction) && this.doShapesFillSquare(direction, world, fromPos, fromBlockState, toPos, toBlockState) && this.canFlowIntoBlock(world, toPos, toBlockState, fluid);
    }

    protected boolean canFlowSource(IBlockReader world, Fluid fluid, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, IFluidState toFluidState) {
        return !this.isSameSource(toFluidState) && this.doShapesFillSquare(direction, world, fromPos, fromBlockState, toPos, toBlockState) && this.canFlowIntoBlock(world, toPos, toBlockState, fluid);
    }

    protected boolean canFlowDown(IBlockReader world, Fluid fluid, BlockPos fromPos, BlockState fromBlockState, BlockPos downPos, BlockState downState) {
        return this.doShapesFillSquare(Direction.DOWN, world, fromPos, fromBlockState, downPos, downState) && (downState.func_204520_s().func_206886_c().func_207187_a((Fluid)this) || this.canFlowIntoBlock(world, downPos, downState, fluid));
    }

    protected int getDelay(World world, BlockPos pos, IFluidState fluidState, IFluidState newFluidState) {
        return this.func_205569_a((IWorldReader)world);
    }

    public void func_207191_a(World world, BlockPos pos, IFluidState fluidState) {
        if (!fluidState.func_206889_d()) {
            IFluidState newFluidState = this.calculateCorrectState((IWorldReader)world, pos, world.func_180495_p(pos));
            int delay = this.getDelay(world, pos, fluidState, newFluidState);
            if (newFluidState.func_206888_e()) {
                fluidState = newFluidState;
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            } else if (!newFluidState.equals(fluidState)) {
                fluidState = newFluidState;
                BlockState blockState = fluidState.func_206883_i();
                world.func_180501_a(pos, blockState, 2);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), delay);
                world.func_195593_d(pos, blockState.func_177230_c());
            }
        }
        this.flowAround((IWorld)world, pos, fluidState);
    }

    protected int getBlockLevelFromState(IFluidState fluidState) {
        int level = (Integer)fluidState.func_177229_b((IProperty)this.levelProperty);
        if (level > this.maxLevel) {
            return this.maxLevel;
        }
        return this.maxLevel - Math.min(fluidState.func_206882_g(), this.maxLevel);
    }

    protected static boolean isFluidAboveSame(IFluidState fluidState, IBlockReader world, BlockPos pos) {
        return fluidState.func_206886_c().func_207187_a(world.func_204610_c(pos.func_177984_a()).func_206886_c());
    }

    public float func_215662_a(IFluidState fluidState, IBlockReader world, BlockPos pos) {
        return fluidState.func_223408_f();
    }

    public float func_223407_a(IFluidState fluidState) {
        return 0.9f * (float)fluidState.func_206882_g() / (float)this.maxLevel;
    }

    public boolean func_207193_c(IFluidState fluidState) {
        return (Integer)fluidState.func_177229_b((IProperty)this.levelProperty) == this.maxLevel;
    }

    public int func_207192_d(IFluidState fluidState) {
        return Math.min(this.maxLevel, (Integer)fluidState.func_177229_b((IProperty)this.levelProperty));
    }

    public VoxelShape func_215664_b(IFluidState fluidState, IBlockReader world, BlockPos pos) {
        return this.shapeMap.computeIfAbsent(fluidState, s -> VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)s.func_215679_a(world, pos), (double)1.0));
    }

    public static int ceilDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) >= 0 && r * y != x) {
            ++r;
        }
        return r;
    }
}

