/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Rarity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.SoundEvent;
import thelm.jaopca.api.fluids.IBucketItemCreator;
import thelm.jaopca.api.fluids.IFluidAttributesCreator;
import thelm.jaopca.api.fluids.IFluidBlockCreator;
import thelm.jaopca.api.fluids.IFluidCreator;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.fluids.JAOPCABucketItem;
import thelm.jaopca.fluids.JAOPCAFluid;
import thelm.jaopca.fluids.JAOPCAFluidAttributes;
import thelm.jaopca.fluids.JAOPCAFluidBlock;
import thelm.jaopca.utils.MiscHelper;

public class FluidFormSettings
implements IFluidFormSettings {
    private IFluidCreator fluidCreator = JAOPCAFluid::new;
    private ToIntFunction<IMaterial> maxLevelFunction = material -> 8;
    private BlockRenderLayer renderLayer = BlockRenderLayer.TRANSLUCENT;
    private ToIntFunction<IMaterial> tickRateFunction = material -> 5;
    private ToDoubleFunction<IMaterial> explosionResistanceFunction = material -> 100.0;
    private Predicate<IMaterial> canSourcesMultiplyFunction = material -> false;
    private IFluidAttributesCreator fluidAttributesCreator = JAOPCAFluidAttributes::new;
    private Supplier<SoundEvent> fillSoundSupplier = () -> null;
    private Supplier<SoundEvent> emptySoundSupplier = () -> null;
    private ToIntFunction<IMaterial> densityFunction = material -> 1000;
    private ToIntFunction<IMaterial> viscosityFunction = material -> this.tickRateFunction.applyAsInt((IMaterial)material) * 200;
    private ToIntFunction<IMaterial> temperatureFunction = material -> 300;
    private Function<IMaterial, Rarity> displayRarityFunction = material -> Rarity.COMMON;
    private IFluidBlockCreator fluidBlockCreator = JAOPCAFluidBlock::new;
    private ToIntFunction<IMaterial> levelDecreasePerBlockFunction = material -> 1;
    private Function<IMaterial, Material> materialFunction = material -> Material.field_151586_h;
    private Function<IMaterial, MaterialColor> materialColorFunction = material -> {
        int color = material.getColor();
        return Arrays.stream(MaterialColor.field_76281_a).filter(Objects::nonNull).min((matColor1, matColor2) -> Integer.compare(MiscHelper.INSTANCE.squareColorDifference(color, matColor1.field_76291_p), MiscHelper.INSTANCE.squareColorDifference(color, matColor2.field_76291_p))).orElse(MaterialColor.field_151668_h);
    };
    private ToIntFunction<IMaterial> lightValueFunction = material -> 0;
    private ToDoubleFunction<IMaterial> blockHardnessFunction = material -> 100.0;
    private ToIntFunction<IMaterial> flammabilityFunction = material -> 0;
    private ToIntFunction<IMaterial> fireSpreadSpeedFunction = material -> 0;
    private Predicate<IMaterial> isFireSourceFunction = material -> false;
    private IBucketItemCreator bucketItemCreator = JAOPCABucketItem::new;
    private ToIntFunction<IMaterial> itemStackLimitFunction = material -> 64;
    private Predicate<IMaterial> beaconPaymentFunction = material -> false;
    private Predicate<IMaterial> hasEffectFunction = material -> material.hasEffect();
    private ToIntFunction<IMaterial> burnTimeFunction = material -> -1;

    FluidFormSettings() {
    }

    @Override
    public IFormType getType() {
        return FluidFormType.INSTANCE;
    }

    @Override
    public IFluidFormSettings setFluidCreator(IFluidCreator fluidCreator) {
        this.fluidCreator = fluidCreator;
        return this;
    }

    @Override
    public IFluidCreator getFluidCreator() {
        return this.fluidCreator;
    }

    @Override
    public IFluidFormSettings setMaxLevelFunction(ToIntFunction<IMaterial> maxLevelFunction) {
        this.maxLevelFunction = maxLevelFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getMaxLevelFunction() {
        return this.maxLevelFunction;
    }

    @Override
    public IFluidFormSettings setRenderLayer(BlockRenderLayer renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    @Override
    public BlockRenderLayer getRenderLayer() {
        return this.renderLayer;
    }

    @Override
    public IFluidFormSettings setTickRateFunction(ToIntFunction<IMaterial> tickRateFunction) {
        this.tickRateFunction = tickRateFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getTickRateFunction() {
        return this.tickRateFunction;
    }

    @Override
    public IFluidFormSettings setExplosionResistanceFunction(ToDoubleFunction<IMaterial> explosionResistanceFunction) {
        this.explosionResistanceFunction = explosionResistanceFunction;
        return this;
    }

    @Override
    public ToDoubleFunction<IMaterial> getExplosionResistanceFunction() {
        return this.explosionResistanceFunction;
    }

    @Override
    public IFluidFormSettings setCanSourcesMultiplyFunction(Predicate<IMaterial> canSourcesMultiplyFunction) {
        this.canSourcesMultiplyFunction = canSourcesMultiplyFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getCanSourcesMultiplyFunction() {
        return this.canSourcesMultiplyFunction;
    }

    @Override
    public IFluidFormSettings setFluidAttributesCreator(IFluidAttributesCreator fluidAttributesCreator) {
        this.fluidAttributesCreator = fluidAttributesCreator;
        return this;
    }

    @Override
    public IFluidAttributesCreator getFluidAttributesCreator() {
        return this.fluidAttributesCreator;
    }

    @Override
    public IFluidFormSettings setFillSoundSupplier(Supplier<SoundEvent> fillSoundSupplier) {
        this.fillSoundSupplier = fillSoundSupplier;
        return this;
    }

    @Override
    public Supplier<SoundEvent> getFillSoundSupplier() {
        return this.fillSoundSupplier;
    }

    @Override
    public IFluidFormSettings setEmptySoundSupplier(Supplier<SoundEvent> emptySoundSupplier) {
        this.emptySoundSupplier = emptySoundSupplier;
        return this;
    }

    @Override
    public Supplier<SoundEvent> getEmptySoundSupplier() {
        return this.emptySoundSupplier;
    }

    @Override
    public IFluidFormSettings setDensityFunction(ToIntFunction<IMaterial> densityFunction) {
        this.densityFunction = densityFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getDensityFunction() {
        return this.densityFunction;
    }

    @Override
    public IFluidFormSettings setViscosityFunction(ToIntFunction<IMaterial> viscosityFunction) {
        this.viscosityFunction = viscosityFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getViscosityFunction() {
        return this.viscosityFunction;
    }

    @Override
    public IFluidFormSettings setTemperatureFunction(ToIntFunction<IMaterial> temperatureFunction) {
        this.temperatureFunction = temperatureFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getTemperatureFunction() {
        return this.temperatureFunction;
    }

    @Override
    public IFluidFormSettings setDisplayRarityFunction(Function<IMaterial, Rarity> displayRarityFunction) {
        this.displayRarityFunction = displayRarityFunction;
        return this;
    }

    @Override
    public Function<IMaterial, Rarity> getDisplayRarityFunction() {
        return this.displayRarityFunction;
    }

    @Override
    public IFluidFormSettings setFluidBlockCreator(IFluidBlockCreator fluidBlockCreator) {
        this.fluidBlockCreator = fluidBlockCreator;
        return this;
    }

    @Override
    public IFluidBlockCreator getFluidBlockCreator() {
        return this.fluidBlockCreator;
    }

    @Override
    public IFluidFormSettings setLevelDecreasePerBlockFunction(ToIntFunction<IMaterial> levelDecreasePerBlockFunction) {
        this.levelDecreasePerBlockFunction = levelDecreasePerBlockFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getLevelDecreasePerBlockFunction() {
        return this.levelDecreasePerBlockFunction;
    }

    @Override
    public IFluidFormSettings setMaterialFunction(Function<IMaterial, Material> materialFunction) {
        this.materialFunction = materialFunction;
        return this;
    }

    @Override
    public Function<IMaterial, Material> getMaterialFunction() {
        return this.materialFunction;
    }

    @Override
    public IFluidFormSettings setMaterialColorFunction(Function<IMaterial, MaterialColor> materialColorFunction) {
        this.materialColorFunction = materialColorFunction;
        return this;
    }

    @Override
    public Function<IMaterial, MaterialColor> getMaterialColorFunction() {
        return this.materialColorFunction;
    }

    @Override
    public IFluidFormSettings setLightValueFunction(ToIntFunction<IMaterial> lightValueFunction) {
        this.lightValueFunction = lightValueFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getLightValueFunction() {
        return this.lightValueFunction;
    }

    @Override
    public IFluidFormSettings setBlockHardnessFunction(ToDoubleFunction<IMaterial> blockHardnessFunction) {
        this.blockHardnessFunction = blockHardnessFunction;
        return this;
    }

    @Override
    public ToDoubleFunction<IMaterial> getBlockHardnessFunction() {
        return this.blockHardnessFunction;
    }

    @Override
    public IFluidFormSettings setFlammabilityFunction(ToIntFunction<IMaterial> flammabilityFunction) {
        this.flammabilityFunction = flammabilityFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getFlammabilityFunction() {
        return this.flammabilityFunction;
    }

    @Override
    public IFluidFormSettings setFireSpreadSpeedFunction(ToIntFunction<IMaterial> fireSpreadSpeedFunction) {
        this.fireSpreadSpeedFunction = fireSpreadSpeedFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getFireSpreadSpeedFunction() {
        return this.fireSpreadSpeedFunction;
    }

    @Override
    public IFluidFormSettings setIsFireSourceFunction(Predicate<IMaterial> isFireSourceFunction) {
        this.isFireSourceFunction = isFireSourceFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getIsFireSourceFunction() {
        return this.isFireSourceFunction;
    }

    @Override
    public IFluidFormSettings setBucketItemCreator(IBucketItemCreator bucketItemCreator) {
        this.bucketItemCreator = bucketItemCreator;
        return this;
    }

    @Override
    public IBucketItemCreator getBucketItemCreator() {
        return this.bucketItemCreator;
    }

    @Override
    public IFluidFormSettings setItemStackLimitFunction(ToIntFunction<IMaterial> itemStackLimitFunction) {
        this.itemStackLimitFunction = itemStackLimitFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getItemStackLimitFunction() {
        return this.itemStackLimitFunction;
    }

    @Override
    public IFluidFormSettings setIsBeaconPaymentFunction(Predicate<IMaterial> beaconPaymentFunction) {
        this.beaconPaymentFunction = beaconPaymentFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getIsBeaconPaymentFunction() {
        return this.beaconPaymentFunction;
    }

    @Override
    public IFluidFormSettings setHasEffectFunction(Predicate<IMaterial> hasEffectFunction) {
        this.hasEffectFunction = hasEffectFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getHasEffectFunction() {
        return this.hasEffectFunction;
    }

    @Override
    public IFluidFormSettings setBurnTimeFunction(ToIntFunction<IMaterial> burnTimeFunction) {
        this.burnTimeFunction = burnTimeFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getBurnTimeFunction() {
        return this.burnTimeFunction;
    }
}

