/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.block;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mods.waterstrainer.tileentity.TileEntityWormBin;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class BlockWormBin
extends Block {
    public BlockWormBin() {
        super(Block.Properties.func_200945_a((Material)Material.field_151578_c).func_200947_a(SoundType.field_185848_a).func_200948_a(2.0f, 5.0f));
        this.setRegistryName("worm_bin");
    }

    public ToolType getHarvestTool(BlockState state) {
        return ToolType.AXE;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        boolean shiftPressed = Screen.hasShiftDown();
        if (shiftPressed) {
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("Valid food items:"));
            for (Item item : TileEntityWormBin.FOODS) {
                if (!item.func_219971_r()) continue;
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList(String.format("- %s: #GREEN#%s", item.func_200296_o().func_150254_d(), WaterStrainerUtils.formPlural(item.func_219967_s().func_221466_a(), "Point", "Points"))));
            }
        } else {
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("Produces Worms and Fertilizer.", "Requires vegetables or fruits.", "Press #GOLD#shift #GRAY#for more info."));
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
            TileEntityWormBin tile = this.getTileEntity((IWorldReader)world, pos);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tile, (BlockPos)pos);
        }
        return true;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntityWormBin tile = this.getTileEntity((IWorldReader)world, pos);
            if (tile != null) {
                WaterStrainerUtils.dropInventoryItems(world, pos, (IItemHandler)tile.inv);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityWormBin();
    }

    public TileEntityWormBin getTileEntity(IWorldReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityWormBin ? (TileEntityWormBin)tile : null;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

