/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.api.data.EnumSortType;
import com.lothrazar.storagenetwork.api.util.NBTHelper;
import com.lothrazar.storagenetwork.block.request.TileRequest;
import com.lothrazar.storagenetwork.gui.ContainerNetworkBase;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class SortMessage {
    private BlockPos pos;
    private boolean direction;
    private EnumSortType sort;

    private SortMessage() {
    }

    public SortMessage(BlockPos pos, boolean direction, EnumSortType sort) {
        this.pos = pos;
        this.direction = direction;
        this.sort = sort;
    }

    public static void handle(SortMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity tileEntity;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player.field_71070_bA instanceof ContainerNetworkBase) {
                tileEntity = player.field_70170_p.func_175625_s(message.pos);
                if (tileEntity instanceof TileRequest) {
                    TileRequest tile = (TileRequest)tileEntity;
                    tile.setSort(message.sort);
                    tile.setDownwards(message.direction);
                }
            } else {
                ItemStack stackPlayerHeld = player.field_71071_by.func_70448_g();
                NBTHelper.setBoolean(stackPlayerHeld, "down", message.direction);
                NBTHelper.setString(stackPlayerHeld, "sort", message.sort.toString());
                return;
            }
            tileEntity.func_70296_d();
        });
    }

    public static SortMessage decode(PacketBuffer buf) {
        SortMessage message = new SortMessage();
        message.pos = buf.func_179259_c();
        message.direction = buf.readBoolean();
        int sort = buf.readInt();
        message.sort = EnumSortType.values()[sort];
        return message;
    }

    public static void encode(SortMessage msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.writeBoolean(msg.direction);
        buf.writeInt(msg.sort.ordinal());
    }
}

