/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.entity.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.stal111.forbidden_arcanus.entity.projectile.EnergyBallEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class EnergyBallRender
extends EntityRenderer<EnergyBallEntity> {
    private static ResourceLocation sphere = new ResourceLocation("forbidden_arcanus", "textures/effect/sphere.png");
    public static final Factory FACTORY = new Factory();

    public EnergyBallRender(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void doRender(EnergyBallEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.depthMask((boolean)false);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.rotateToPlayer();
        this.func_110776_a(sphere);
        GlStateManager.enableRescaleNormal();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)1, (int)1);
        long t = System.currentTimeMillis() % 6L;
        this.renderBillboardQuad(0.3f, (float)t * 0.25f, 0.25f);
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.popMatrix();
    }

    private void renderBillboardQuad(double scale, float vAdd1, float vAdd2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(-scale, -scale, 0.0).func_187315_a(0.0, (double)(0.0f + vAdd1)).func_181675_d();
        buffer.func_181662_b(-scale, scale, 0.0).func_187315_a(0.0, (double)(0.0f + vAdd1 + vAdd2)).func_181675_d();
        buffer.func_181662_b(scale, scale, 0.0).func_187315_a(1.0, (double)(0.0f + vAdd1 + vAdd2)).func_181675_d();
        buffer.func_181662_b(scale, -scale, 0.0).func_187315_a(1.0, (double)(0.0f + vAdd1)).func_181675_d();
        tessellator.func_78381_a();
    }

    private void rotateToPlayer() {
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        GlStateManager.rotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    protected ResourceLocation getEntityTexture(EnergyBallEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    public static class Factory
    implements IRenderFactory<EnergyBallEntity> {
        public EntityRenderer<? super EnergyBallEntity> createRenderFor(EntityRendererManager manager) {
            return new EnergyBallRender(manager);
        }
    }
}

