/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.block.tileentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stal111.forbidden_arcanus.block.tileentity.ModTileEntities;
import com.stal111.forbidden_arcanus.block.tileentity.container.DarkBeaconContainer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DarkBeaconTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    public static final Effect[][] EFFECTS_LIST = new Effect[][]{{Effects.field_76424_c, Effects.field_76422_e}, {Effects.field_76429_m, Effects.field_76430_j}, {Effects.field_76420_g}, {Effects.field_76428_l}};
    private static final Set<Effect> VALID_EFFECTS = Arrays.stream(EFFECTS_LIST).flatMap(Arrays::stream).collect(Collectors.toSet());
    private List<BeamSegment> beamSegments = Lists.newArrayList();
    private List<BeamSegment> field_213934_g = Lists.newArrayList();
    private int levels = 0;
    private int field_213935_i = -1;
    @Nullable
    private Effect primaryEffect;
    @Nullable
    private Effect secondaryEffect;
    @Nullable
    private ITextComponent customName;
    private LockCode field_213936_m = LockCode.field_180162_a;
    private final IIntArray field_213937_n = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return DarkBeaconTileEntity.this.levels;
                }
                case 1: {
                    return Effect.func_188409_a((Effect)DarkBeaconTileEntity.this.primaryEffect);
                }
                case 2: {
                    return Effect.func_188409_a((Effect)DarkBeaconTileEntity.this.secondaryEffect);
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    DarkBeaconTileEntity.this.levels = value;
                    break;
                }
                case 1: {
                    if (!((DarkBeaconTileEntity)DarkBeaconTileEntity.this).field_145850_b.field_72995_K && !DarkBeaconTileEntity.this.beamSegments.isEmpty()) {
                        DarkBeaconTileEntity.this.playSound(SoundEvents.field_206941_N);
                    }
                    DarkBeaconTileEntity.this.primaryEffect = DarkBeaconTileEntity.isBeaconEffect(value);
                    break;
                }
                case 2: {
                    DarkBeaconTileEntity.this.secondaryEffect = DarkBeaconTileEntity.isBeaconEffect(value);
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public DarkBeaconTileEntity() {
        super(ModTileEntities.dark_beacon);
    }

    public void func_73660_a() {
        BlockPos blockpos;
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        if (this.field_213935_i < j) {
            blockpos = this.field_174879_c;
            this.field_213934_g = Lists.newArrayList();
            this.field_213935_i = blockpos.func_177956_o() - 1;
        } else {
            blockpos = new BlockPos(i, this.field_213935_i + 1, k);
        }
        BeamSegment beacontileentity$beamsegment = this.field_213934_g.isEmpty() ? null : this.field_213934_g.get(this.field_213934_g.size() - 1);
        int l = this.field_145850_b.func_201676_a(Heightmap.Type.WORLD_SURFACE, i, k);
        for (int i1 = 0; i1 < 10 && blockpos.func_177956_o() <= l; ++i1) {
            BlockState blockstate = this.field_145850_b.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            float[] afloat = blockstate.getBeaconColorMultiplier((IWorldReader)this.field_145850_b, blockpos, this.func_174877_v());
            if (afloat != null) {
                if (this.field_213934_g.size() <= 1) {
                    beacontileentity$beamsegment = new BeamSegment(afloat);
                    this.field_213934_g.add(beacontileentity$beamsegment);
                } else if (beacontileentity$beamsegment != null) {
                    if (Arrays.equals(afloat, beacontileentity$beamsegment.colors)) {
                        beacontileentity$beamsegment.incrementHeight();
                    } else {
                        beacontileentity$beamsegment = new BeamSegment(new float[]{(beacontileentity$beamsegment.colors[0] + afloat[0]) / 2.0f, (beacontileentity$beamsegment.colors[1] + afloat[1]) / 2.0f, (beacontileentity$beamsegment.colors[2] + afloat[2]) / 2.0f});
                        this.field_213934_g.add(beacontileentity$beamsegment);
                    }
                }
            } else {
                if (beacontileentity$beamsegment == null || blockstate.func_200016_a((IBlockReader)this.field_145850_b, blockpos) >= 15 && block != Blocks.field_150357_h) {
                    this.field_213934_g.clear();
                    this.field_213935_i = l;
                    break;
                }
                beacontileentity$beamsegment.incrementHeight();
            }
            blockpos = blockpos.func_177984_a();
            ++this.field_213935_i;
        }
        int j1 = this.levels;
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            if (!this.beamSegments.isEmpty()) {
                this.func_213927_a(i, j, k);
            }
            if (this.levels > 0 && !this.beamSegments.isEmpty()) {
                this.addEffectsToPlayers();
                this.playSound(SoundEvents.field_206939_L);
            }
        }
        if (this.field_213935_i >= l) {
            this.field_213935_i = -1;
            boolean flag = j1 > 0;
            this.beamSegments = this.field_213934_g;
            if (!this.field_145850_b.field_72995_K) {
                boolean flag1;
                boolean bl = flag1 = this.levels > 0;
                if (!flag && flag1) {
                    this.playSound(SoundEvents.field_206938_K);
                    for (ServerPlayerEntity serverPlayerEntity : this.field_145850_b.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB((double)i, (double)j, (double)k, (double)i, (double)(j - 4), (double)k).func_72314_b(10.0, 5.0, 10.0))) {
                    }
                } else if (flag && !flag1) {
                    this.playSound(SoundEvents.field_206940_M);
                }
            }
        }
    }

    private void func_213927_a(int p_213927_1_, int p_213927_2_, int p_213927_3_) {
        int j;
        this.levels = 0;
        int i = 1;
        while (i <= 4 && (j = p_213927_2_ - i) >= 0) {
            boolean flag = true;
            block1: for (int k = p_213927_1_ - i; k <= p_213927_1_ + i && flag; ++k) {
                for (int l = p_213927_3_ - i; l <= p_213927_3_ + i; ++l) {
                    if (this.field_145850_b.func_180495_p(new BlockPos(k, j, l)).isBeaconBase((IWorldReader)this.field_145850_b, new BlockPos(k, j, l), this.func_174877_v())) continue;
                    flag = false;
                    continue block1;
                }
            }
            if (!flag) break;
            this.levels = i++;
        }
    }

    public void func_145843_s() {
        this.playSound(SoundEvents.field_206940_M);
        super.func_145843_s();
    }

    private void addEffectsToPlayers() {
        if (!this.field_145850_b.field_72995_K && this.primaryEffect != null) {
            double d0 = this.levels * 10 + 10;
            int i = 0;
            if (this.levels >= 4 && this.primaryEffect == this.secondaryEffect) {
                i = 1;
            }
            int j = (9 + this.levels * 2) * 20;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_174879_c).func_186662_g(d0).func_72321_a(0.0, (double)this.field_145850_b.func_217301_I(), 0.0);
            List list = this.field_145850_b.func_217357_a(PlayerEntity.class, axisalignedbb);
            for (PlayerEntity playerentity : list) {
                playerentity.func_195064_c(new EffectInstance(this.primaryEffect, j, i, true, true));
            }
            if (this.levels >= 4 && this.primaryEffect != this.secondaryEffect && this.secondaryEffect != null) {
                for (PlayerEntity playerentity1 : list) {
                    playerentity1.func_195064_c(new EffectInstance(this.secondaryEffect, j, 0, true, true));
                }
            }
        }
    }

    public void playSound(SoundEvent p_205736_1_) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, p_205736_1_, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<BeamSegment> getBeamSegments() {
        return this.levels == 0 ? ImmutableList.of() : this.beamSegments;
    }

    public int getLevels() {
        return this.levels;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Nullable
    private static Effect isBeaconEffect(int p_184279_0_) {
        Effect effect = Effect.func_188412_a((int)p_184279_0_);
        return VALID_EFFECTS.contains(effect) ? effect : null;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.primaryEffect = DarkBeaconTileEntity.isBeaconEffect(compound.func_74762_e("Primary"));
        this.secondaryEffect = DarkBeaconTileEntity.isBeaconEffect(compound.func_74762_e("Secondary"));
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName"));
        }
        this.field_213936_m = LockCode.func_180158_b((CompoundNBT)compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Primary", Effect.func_188409_a((Effect)this.primaryEffect));
        compound.func_74768_a("Secondary", Effect.func_188409_a((Effect)this.secondaryEffect));
        compound.func_74768_a("Levels", this.levels);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        this.field_213936_m.func_180157_a(compound);
        return compound;
    }

    public void setCustomName(@Nullable ITextComponent aname) {
        this.customName = aname;
    }

    @Nullable
    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        return LockableTileEntity.func_213905_a((PlayerEntity)p_createMenu_3_, (LockCode)this.field_213936_m, (ITextComponent)this.func_145748_c_()) ? new DarkBeaconContainer(p_createMenu_1_, (IInventory)p_createMenu_2_, this.field_213937_n, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.func_174877_v())) : null;
    }

    public ITextComponent func_145748_c_() {
        return this.customName != null ? this.customName : new TranslationTextComponent("container.dark_beacon", new Object[0]);
    }

    public static class BeamSegment {
        private final float[] colors;
        private int height;

        public BeamSegment(float[] colorsIn) {
            this.colors = colorsIn;
            this.height = 1;
        }

        protected void incrementHeight() {
            ++this.height;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float[] getColors() {
            return this.colors;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getHeight() {
            return this.height;
        }
    }
}

