/*
 * Decompiled with CFR 0.152.
 */
package atm.bloodworkxgaming.serverstarter.packtype.zip;

import atm.bloodworkxgaming.serverstarter.ServerStarter;
import atm.bloodworkxgaming.serverstarter.config.ConfigFile;
import atm.bloodworkxgaming.serverstarter.logger.PrimitiveLogger;
import atm.bloodworkxgaming.serverstarter.packtype.AbstractZipbasedPackType;
import atm.bloodworkxgaming.serverstarter.packtype.AbstractZipbasedPackTypeKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0014J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u000fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Latm/bloodworkxgaming/serverstarter/packtype/zip/ZipFilePackType;", "Latm/bloodworkxgaming/serverstarter/packtype/AbstractZipbasedPackType;", "configFile", "Latm/bloodworkxgaming/serverstarter/config/ConfigFile;", "(Latm/bloodworkxgaming/serverstarter/config/ConfigFile;)V", "forgeVersion", "", "mcVersion", "oldFiles", "Ljava/io/File;", "cleanUrl", "url", "getForgeVersion", "getMCVersion", "handleZip", "", "file", "pathMatchers", "", "Ljava/nio/file/PathMatcher;", "postProcessing", "serverstarter"})
public final class ZipFilePackType
extends AbstractZipbasedPackType {
    private String forgeVersion;
    private String mcVersion;
    private final File oldFiles;

    @Override
    @NotNull
    protected String cleanUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        return url;
    }

    @Override
    protected void postProcessing() {
    }

    @Override
    @NotNull
    public String getForgeVersion() {
        return this.forgeVersion;
    }

    @Override
    @NotNull
    public String getMCVersion() {
        return this.mcVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleZip(@NotNull File file, @NotNull List<? extends PathMatcher> pathMatchers) throws IOException {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(pathMatchers, "pathMatchers");
        FileUtils.deleteDirectory(this.oldFiles);
        PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Starting to unzip files.", false, 2, null);
        try {
            Closeable closeable = new ZipInputStream(new FileInputStream(file));
            Throwable throwable = null;
            try {
                ZipInputStream zis = (ZipInputStream)closeable;
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    boolean bl;
                    String path;
                    String name;
                    block17: {
                        ServerStarter.Companion.getLOGGER().info("Entry in zip: " + entry, true);
                        name = entry.getName();
                        path = entry.getName();
                        Iterable $receiver$iv = pathMatchers;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $receiver$iv) {
                                PathMatcher it = (PathMatcher)element$iv;
                                if (!it.matches(Paths.get(path, new String[0]))) continue;
                                bl = true;
                                break block17;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        ServerStarter.Companion.getLOGGER().info("Skipping " + path + " as it is on the ignore List.", true);
                    } else {
                        String string = name;
                        Intrinsics.checkExpressionValueIsNotNull(string, "name");
                        if (!StringsKt.endsWith$default(string, "/", false, 2, null)) {
                            File outfile = new File(this.getBasePath() + path);
                            ServerStarter.Companion.getLOGGER().info("Copying zip entry to = " + outfile, true);
                            File file2 = outfile.getParentFile();
                            if (file2 != null) {
                                file2.mkdirs();
                            }
                            AbstractZipbasedPackTypeKt.writeToFile(zis, outfile);
                        } else {
                            File newFolder = new File(this.getBasePath() + path);
                            if (newFolder.exists()) {
                                FileUtils.moveDirectory(newFolder, new File(this.oldFiles, path));
                            }
                            ServerStarter.Companion.getLOGGER().info("Folder moved: " + newFolder.getAbsolutePath(), true);
                        }
                    }
                    entry = zis.getNextEntry();
                }
                zis.closeEntry();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            ServerStarter.Companion.getLOGGER().error("Could not unzip files", e);
        }
        PrimitiveLogger.info$default(ServerStarter.Companion.getLOGGER(), "Done unzipping the files.", false, 2, null);
    }

    public ZipFilePackType(@NotNull ConfigFile configFile) {
        Intrinsics.checkParameterIsNotNull(configFile, "configFile");
        super(configFile);
        this.forgeVersion = configFile.getInstall().getForgeVersion();
        this.mcVersion = configFile.getInstall().getMcVersion();
        this.oldFiles = new File(this.getBasePath() + "OLD_TO_DELETE/");
    }
}

