/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="silentlib")
public final class EntityHelper {
    private static volatile Queue<Entity> entitiesToSpawn = new ConcurrentLinkedDeque<Entity>();

    private EntityHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static void safeSpawn(Entity entity) {
        entitiesToSpawn.add(entity);
    }

    private static void handleSpawns() {
        Entity entity;
        while ((entity = entitiesToSpawn.poll()) != null) {
            entity.field_70170_p.func_217376_c(entity);
        }
    }

    public static void heal(LivingEntity entityLiving, float healAmount, boolean cancelable) {
        if (cancelable) {
            entityLiving.func_70691_i(healAmount);
        } else {
            entityLiving.func_70606_j(entityLiving.func_110143_aJ() + healAmount);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityHelper.handleSpawns();
        }
    }
}

