/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.tooltip;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.tooltip.ITooltipBuilder;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class QuickTooltips {
    public static final Supplier<Boolean> SHIFT = new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            return InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)344);
        }
    };
    public static final Supplier<Boolean> CTRL = new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            return InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)341) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)345);
        }
    };

    public static Conditional createConditional(Supplier<Boolean> supplier) {
        return new Conditional(supplier);
    }

    public static List createBuilder() {
        return new List();
    }

    public static class Conditional
    implements ITooltipBuilder {
        protected Supplier<Boolean> condition;
        protected java.util.List trueValues = Lists.newArrayList();
        protected java.util.List falseValues = Lists.newArrayList();

        public Conditional(Supplier<Boolean> condition) {
            this.condition = condition;
        }

        public Conditional addTrue(ITextComponent comp) {
            this.trueValues.add(comp);
            return this;
        }

        public Conditional addTrueString(String str) {
            if (!StringUtils.isNullOrEmpty(str)) {
                this.trueValues.add(new StringTextComponent(str));
            }
            return this;
        }

        public Conditional addFalse(ITextComponent comp) {
            this.falseValues.add(comp);
            return this;
        }

        public Conditional addFalseString(String str) {
            if (!StringUtils.isNullOrEmpty(str)) {
                this.falseValues.add(new StringTextComponent(str));
            }
            return this;
        }

        public boolean getState() {
            return this.condition.get();
        }

        public java.util.List build() {
            if (this.condition.get().booleanValue()) {
                return this.trueValues;
            }
            return this.falseValues;
        }
    }

    public static class List
    implements ITooltipBuilder {
        private java.util.List tooltips = Lists.newArrayList();

        public List add(ITextComponent tooltip) {
            this.tooltips.add(tooltip);
            return this;
        }

        public List addString(String tooltip) {
            if (!StringUtils.isNullOrEmpty(tooltip)) {
                this.tooltips.add(new StringTextComponent(tooltip));
            }
            return this;
        }

        public void buildTo(java.util.List tooltips) {
            tooltips.addAll(this.tooltips);
        }

        public java.util.List build() {
            return this.tooltips;
        }
    }
}

