/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.theme.client;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.base.ButtonThemeColor;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.base.ButtonThemeSizableBox;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.base.ButtonThemeTexture;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.Color4;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiSizableBox;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiTexture;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistry;
import java.util.Map;

public abstract class Theme {
    protected ThemeRegistry reg;
    protected Map<AssetID, GuiSizableBox> boxMap = Maps.newHashMap();
    protected Map<AssetID, Color4> colorMap = Maps.newHashMap();
    protected Map<AssetID, GuiTexture> textureMap = Maps.newHashMap();
    protected Map<AssetID, ButtonThemeColor> buttonThemeColorMap = Maps.newHashMap();
    protected Map<AssetID, ButtonThemeSizableBox> buttonThemeSizableBoxMap = Maps.newHashMap();
    protected Map<AssetID, ButtonThemeTexture> buttonThemeTextureMap = Maps.newHashMap();

    protected Theme() {
        this.addAssets();
    }

    protected abstract void addAssets();

    public GuiSizableBox getSizableBox(AssetID id) {
        GuiSizableBox r = this.boxMap.get(id);
        return r != null ? r : this.reg.getTheme(this.reg.getDefault()).getSizableBox(id);
    }

    public Color4 getColor(AssetID id) {
        Color4 r = this.colorMap.get(id);
        return r != null ? r : this.reg.getTheme(this.reg.getDefault()).getColor(id);
    }

    public GuiTexture getTexture(AssetID id) {
        GuiTexture r = this.textureMap.get(id);
        return r != null ? r : this.reg.getTheme(this.reg.getDefault()).getTexture(id);
    }

    public ButtonThemeColor getButtonColorTheme(AssetID id) {
        ButtonThemeColor r = this.buttonThemeColorMap.get(id);
        return r != null ? r : this.reg.getTheme(this.reg.getDefault()).getButtonColorTheme(id);
    }

    public ButtonThemeSizableBox getButtonSizableBoxTheme(AssetID id) {
        ButtonThemeSizableBox r = this.buttonThemeSizableBoxMap.get(id);
        return r != null ? r : this.reg.getTheme(this.reg.getDefault()).getButtonSizableBoxTheme(id);
    }

    public ButtonThemeTexture getButtonTextureTheme(AssetID id) {
        ButtonThemeTexture r = this.buttonThemeTextureMap.get(id);
        return r != null ? r : this.reg.getTheme(this.reg.getDefault()).getButtonTextureTheme(id);
    }

    protected void addBox(AssetID id, GuiSizableBox box) {
        if (id == null || box == null || this.boxMap.containsKey(id)) {
            return;
        }
        this.boxMap.put(id, box);
    }

    protected void addColor(AssetID id, Color4 color) {
        if (id == null || color == null || this.colorMap.containsKey(id)) {
            return;
        }
        this.colorMap.put(id, color);
    }

    protected void addTexture(AssetID id, GuiTexture texture) {
        if (id == null || texture == null || this.textureMap.containsKey(id)) {
            return;
        }
        this.textureMap.put(id, texture);
    }

    protected void addButtonColorTheme(AssetID id, ButtonThemeColor theme) {
        if (id == null || theme == null || this.buttonThemeColorMap.containsKey(id)) {
            return;
        }
        this.buttonThemeColorMap.put(id, theme);
    }

    protected void addButtonSizableBoxTheme(AssetID id, ButtonThemeSizableBox theme) {
        if (id == null || theme == null || this.buttonThemeSizableBoxMap.containsKey(id)) {
            return;
        }
        this.buttonThemeSizableBoxMap.put(id, theme);
    }

    protected void addButtonTextureTheme(AssetID id, ButtonThemeTexture theme) {
        if (id == null || theme == null || this.buttonThemeTextureMap.containsKey(id)) {
            return;
        }
        this.buttonThemeTextureMap.put(id, theme);
    }
}

