/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    public static void initContainerAll(@NotNull List<IElement> elements) {
        elements.forEach(ele -> {
            if (ele instanceof IElementContainer) {
                ((IElementContainer)((Object)ele)).initContainer();
            }
        });
    }

    public static int getElementsAddedSizeX(@NotNull List<IElement> elements) {
        int sizeX = 0;
        for (IElement ele : elements) {
            sizeX += ele.getSizeX();
        }
        return sizeX;
    }

    public static int getElementsAddedSizeY(@NotNull List<IElement> elements) {
        int sizeY = 0;
        for (IElement ele : elements) {
            sizeY += ele.getSizeY();
        }
        return sizeY;
    }

    public static void updateAll(@NotNull List<IElement> elements) {
        elements.forEach(ele -> {
            if (ele instanceof IElementUpdate) {
                ((IElementUpdate)((Object)ele)).update();
            }
        });
    }

    public static void onThemeChangedAll(@NotNull List<IElement> elements, Theme theme) {
        elements.forEach(ele -> ele.onThemeChanged(theme));
    }

    public static void drawBackground(@NotNull List<IElement> elements, int mouseX, int mouseY, float partialTicks, IElementContainer container) {
        elements.forEach(ele -> {
            if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isBackgroundVisible()) {
                ((IElementDraw)((Object)ele)).drawBackground(mouseX, mouseY, partialTicks);
            }
        });
    }

    public static void drawForeground(@NotNull List<IElement> elements, int mouseX, int mouseY, IElementContainer container) {
        elements.forEach(ele -> {
            if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isForegroundVisible()) {
                ((IElementDraw)((Object)ele)).drawForeground(mouseX, mouseY);
            }
        });
    }

    public static boolean mouseClickedCheckAll(@NotNull List<IElement> elements, double mouseX, double mouseY, int mouseButton, @NotNull IElementContainer container) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mouseX, (int)mouseY);
        if (container.withinBounds((int)mouseX, (int)mouseY)) {
            for (IElement ele : elements) {
                if (!ele.livesOutsideContainer() || !inCont || !(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).mouseClicked(mouseX, mouseY, mouseButton)) continue;
                r = true;
                container.mouseClickedResponse(ele, mouseX, mouseY, mouseButton);
            }
        }
        return r;
    }

    public static boolean mouseReleasedCheckAll(@NotNull List<IElement> elements, double mouseX, double mouseY, int mouseButton, @NotNull IElementContainer container) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mouseX, (int)mouseY);
        for (IElement ele : elements) {
            if (!ele.livesOutsideContainer() || !inCont || !(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).mouseReleased(mouseX, mouseY, mouseButton)) continue;
            r = true;
            container.mouseReleasedResponse(ele, mouseX, mouseY, mouseButton);
        }
        return r;
    }

    public static boolean mouseDraggedCheckAll(@NotNull List<IElement> elements, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd, @NotNull IElementContainer container) {
        boolean r = false;
        boolean inCont = container.withinBounds((int)mouseXStart, (int)mouseYStart);
        for (IElement ele : elements) {
            if (!ele.livesOutsideContainer() || !inCont || !(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).mouseDragged(mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd)) continue;
            r = true;
            container.mouseDraggedResponse(ele, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
        }
        return r;
    }

    public static boolean mouseScrolledCheckAll(@NotNull List<IElement> elements, double scrolled, @NotNull IElementContainer container) {
        boolean r = false;
        for (IElement ele : elements) {
            if (!(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).mouseScrolled(scrolled)) continue;
            r = true;
            container.mouseScrolledResponse(ele, scrolled);
        }
        return r;
    }

    public static boolean keyPressedCheckAll(@NotNull List<IElement> elements, int key, int scanCode, int modifiers, @NotNull IElementContainer container) {
        boolean r = false;
        for (IElement ele : elements) {
            if (!(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).keyPressed(key, scanCode, modifiers)) continue;
            r = true;
            container.keyPressedResponse(ele, key, scanCode, modifiers);
        }
        return r;
    }

    public static boolean keyReleasedCheckAll(@NotNull List<IElement> elements, int key, int scanCode, int modifiers, @NotNull IElementContainer container) {
        boolean r = false;
        for (IElement ele : elements) {
            if (!(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).keyReleased(key, scanCode, modifiers)) continue;
            r = true;
            container.keyReleasedResponse(ele, key, scanCode, modifiers);
        }
        return r;
    }

    public static boolean charTypedCheckAll(@NotNull List<IElement> elements, char ch, int modifiers, @NotNull IElementContainer container) {
        boolean r = false;
        for (IElement ele : elements) {
            if (!(ele instanceof IElementInput) || !((IElementInput)((Object)ele)).charTyped(ch, modifiers)) continue;
            r = true;
            container.charTypedResponse(ele, ch, modifiers);
        }
        return r;
    }

    public static void guiScissorStart(int x, int y, int w, int h) {
        double d = Minecraft.func_71410_x().field_195558_d.func_198100_s();
        int sx = (int)((double)x * d);
        int sy = (int)((double)y * d);
        int sw = (int)((double)w * d);
        int sh = (int)((double)h * d);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
    }

    public static void guiScissorEnd() {
        GL11.glDisable((int)3089);
    }

    public static void out(String data) {
        System.out.println(data);
    }

    public static boolean isInBox(int xIn, int yIn, int boxX, int boxY, int boxW, int boxH) {
        return xIn >= boxX && xIn < boxX + boxW && yIn >= boxY && yIn < boxY + boxH;
    }

    public static void drawTexturedRect(AbstractGui obj, int x, int y, int u, int v, int w, int h) {
        obj.blit(x, y, u, v, w, h);
    }

    public static void drawTexturedRect(AbstractGui obj, int x, int y, int u, int v, int w, int h, int texWidth, int texHeight) {
        AbstractGui.blit((int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)texWidth, (int)texHeight);
    }

    public static void drawTexturedRect(AbstractGui obj, int x, int y, int u, int v, int w, int h, int rendW, int rendH, int texW, int texH) {
        AbstractGui.blit((int)x, (int)y, (int)u, (int)v, (float)w, (float)h, (int)rendW, (int)rendH, (int)texW, (int)texH);
    }
}

