/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting;

import com.blakebr0.cucumber.crafting.ISpecialRecipeSerializer;
import com.blakebr0.cucumber.crafting.ISpecialRecipeType;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.IItemHandler;

public interface ISpecialRecipe {
    public ItemStack getOutput();

    public NonNullList<Ingredient> getIngredients();

    public ResourceLocation getId();

    public ISpecialRecipeSerializer<?> getSerializer();

    public ISpecialRecipeType<?> getType();

    default public boolean matches(IItemHandler inventory) {
        return this.matches(inventory, 0, inventory.getSlots());
    }

    default public boolean matches(IItemHandler inventory, int startIndex, int endIndex) {
        NonNullList inputs = NonNullList.func_191196_a();
        for (int i = startIndex; i < endIndex; ++i) {
            inputs.add((Object)inventory.getStackInSlot(i));
        }
        return RecipeMatcher.findMatches((List)inputs, this.getIngredients()) != null;
    }

    default public NonNullList<ItemStack> getRemainingItems(IItemHandler inventory) {
        NonNullList remaining = NonNullList.func_191197_a((int)inventory.getSlots(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!stack.hasContainerItem()) continue;
            remaining.set(i, (Object)stack.getContainerItem());
        }
        return remaining;
    }
}

