/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidTools {
    @Nonnull
    public static ItemStack convertFluidToBucket(@Nonnull FluidStack fluidStack) {
        return (ItemStack)FluidUtil.getFluidHandler((ItemStack)new ItemStack((IItemProvider)Items.field_151133_ar)).map(handler -> {
            handler.fill(fluidStack, true);
            return handler.getContainer();
        }).orElse((Object)ItemStack.field_190927_a);
    }

    @Nullable
    public static FluidStack convertBucketToFluid(@Nonnull ItemStack bucket) {
        return (FluidStack)FluidUtil.getFluidHandler((ItemStack)bucket).map(handler -> {
            IFluidTankProperties[] tankProperties;
            for (IFluidTankProperties properties : tankProperties = handler.getTankProperties()) {
                FluidStack contents = properties.getContents();
                if (contents == null) continue;
                return contents;
            }
            return null;
        }).orElse(null);
    }

    public static boolean isEmptyContainer(@Nonnull ItemStack itemStack) {
        return (Boolean)FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> {
            IFluidTankProperties[] tankProperties;
            for (IFluidTankProperties properties : tankProperties = handler.getTankProperties()) {
                if (!properties.canFill() || properties.getCapacity() <= 0) continue;
                FluidStack contents = properties.getContents();
                if (contents == null) {
                    return true;
                }
                if (contents.amount <= 0) continue;
                return false;
            }
            return false;
        }).orElse((Object)false);
    }

    public static boolean isFilledContainer(@Nonnull ItemStack itemStack) {
        return (Boolean)FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> {
            IFluidTankProperties[] tankProperties;
            for (IFluidTankProperties properties : tankProperties = handler.getTankProperties()) {
                if (!properties.canDrain()) {
                    return false;
                }
                FluidStack contents = properties.getContents();
                if (contents != null && contents.amount >= properties.getCapacity()) continue;
                return false;
            }
            return true;
        }).orElse((Object)false);
    }

    @Nonnull
    public static ItemStack drainContainer(@Nonnull ItemStack container) {
        ItemStack empty = container.func_77946_l();
        empty.func_190920_e(1);
        return (ItemStack)FluidUtil.getFluidHandler((ItemStack)empty).map(handler -> {
            if (handler.drain(Integer.MAX_VALUE, true) != null) {
                return handler.getContainer();
            }
            return ItemStack.field_190927_a;
        }).orElse((Object)ItemStack.field_190927_a);
    }

    @Nonnull
    public static ItemStack fillContainer(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        return (ItemStack)FluidUtil.getFluidHandler((ItemStack)itemStack.func_77946_l()).map(handler -> {
            int filled = handler.fill(fluidStack, true);
            if (filled == 0) {
                return ItemStack.field_190927_a;
            }
            return handler.getContainer();
        }).orElse((Object)ItemStack.field_190927_a);
    }

    public static int getCapacity(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        return (Integer)FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> {
            IFluidTankProperties[] tankProperties;
            for (IFluidTankProperties properties : tankProperties = handler.getTankProperties()) {
                if (!properties.canDrainFluidType(fluidStack)) continue;
                return properties.getCapacity();
            }
            return 0;
        }).orElse((Object)0);
    }
}

