/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetRepository;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public abstract class AbstractContainerWidget<P extends AbstractContainerWidget<P>>
extends AbstractWidget<P> {
    private final List<Widget<?>> children = new ArrayList();

    public AbstractContainerWidget(Minecraft mc, Screen gui) {
        super(mc, gui);
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.markDirty();
        super.setBounds(bounds);
    }

    @Override
    public Widget<?> getWidgetAtPosition(int x, int y) {
        x -= this.bounds.x;
        y -= this.bounds.y;
        for (Widget<?> child : this.children) {
            if (!child.in(x, y) || !child.isVisible()) continue;
            return child.getWidgetAtPosition(x, y);
        }
        return this;
    }

    @Override
    public boolean mouseWheel(int amount, int x, int y) {
        x -= this.bounds.x;
        y -= this.bounds.y;
        for (Widget<?> child : this.children) {
            if (!child.in(x, y) || !child.isVisible() || !child.mouseWheel(amount, x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsWidget(Widget<?> w) {
        if (w == this) {
            return true;
        }
        for (Widget<?> child : this.children) {
            if (!child.containsWidget(w)) continue;
            return true;
        }
        return false;
    }

    public P addChildren(Widget<?> ... children) {
        for (Widget<?> child : children) {
            this.addChild(child);
        }
        return (P)this;
    }

    public P addChild(Widget<?> child) {
        if (child == null) {
            throw new RuntimeException("THIS IS NOT POSSIBLE!");
        }
        this.children.add(child);
        this.markDirty();
        return (P)this;
    }

    public P removeChild(Widget<?> child) {
        this.children.remove(child);
        this.markDirty();
        return (P)this;
    }

    public void removeChildren() {
        this.children.clear();
        this.markDirty();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public List<Widget<?>> getChildren() {
        return this.children;
    }

    public Widget<?> getChild(int index) {
        return this.children.get(index);
    }

    public Widget<?> findChild(String name) {
        for (Widget<?> child : this.children) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public Widget<?> findChildRecursive(String name) {
        for (Widget<?> child : this.children) {
            Widget<?> widget;
            if (name.equals(child.getName())) {
                return child;
            }
            if (!(child instanceof AbstractContainerWidget) || (widget = ((AbstractContainerWidget)child).findChildRecursive(name)) == null) continue;
            return widget;
        }
        return null;
    }

    @Override
    public void readFromGuiCommand(GuiParser.GuiCommand command) {
        super.readFromGuiCommand(command);
        command.commands().forEach(cmd -> {
            String type = cmd.getId();
            Widget<?> widget = WidgetRepository.createWidget(type, this.mc, this.gui);
            if (widget != null) {
                widget.readFromGuiCommand((GuiParser.GuiCommand)cmd);
                this.children.add(widget);
            }
        });
    }

    @Override
    public void fillGuiCommand(GuiParser.GuiCommand command) {
        super.fillGuiCommand(command);
        for (Widget<?> child : this.children) {
            GuiParser.GuiCommand childCommand = child.createGuiCommand();
            child.fillGuiCommand(childCommand);
            command.command(childCommand);
        }
    }
}

